% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdyplFit.R
\name{sloe}
\alias{sloe}
\title{Estimate the corrupted signal strength in a model with
(sub-)Gaussian covariates}
\usage{
sloe(object)
}
\arguments{
\item{object}{an \code{\link[=mdyplFit]{"mdyplFit"}} object.}
}
\value{
A scalar.
}
\description{
Estimate the corrupted signal strength in a model with
(sub-)Gaussian covariates
}
\details{
The Signal Strength Leave-One-Out Estimator (SLOE) is defined in
Yadlowsky et al. (2021) when the model is estimated using maximum
likelihood (i.e. when \code{object$alpha = 1}; see \code{\link[=mdyplControl]{mdyplControl()}} for
what \code{alpha} is). The SLOE adaptation when estimation is through
maximum Diaconis-Ylvisaker prior penalized likelihood
(\code{\link[=mdypl_fit]{mdypl_fit()}}) has been put forward in Sterzinger & Kosmidis
(2025).

In particular, \code{\link[=sloe]{sloe()}} computes an estimate of the corrupted
signal strength which is the limit \deqn{\nu^2} of \eqn{var(X
\hat\beta(\alpha))}, where \eqn{\hat\beta(\alpha)} is the maximum
Diaconis-Ylvisaker prior penalized likelihood (MDYPL) estimator as
computed by \code{\link[=mdyplFit]{mdyplFit()}} with shrinkage parameter \eqn{alpha}.
}
\references{
Sterzinger P, Kosmidis I (2024). Diaconis-Ylvisaker prior
penalized likelihood for \eqn{p/n \to \kappa \in (0,1)} logistic
regression. \emph{arXiv}:2311.07419v2, \url{https://arxiv.org/abs/2311.07419}.

Yadlowsky S, Yun T, McLean C Y, D' Amour A (2021). SLOE: A Faster
Method for Statistical Inference in High-Dimensional Logistic
Regression. In M Ranzato, A Beygelzimer, Y Dauphin, P Liang, J W
Vaughan (eds.), \emph{Advances in Neural Information Processing
Systems}, \strong{34}, 29517–29528. Curran Associates,
Inc. \url{https://proceedings.neurips.cc/paper_files/paper/2021/file/f6c2a0c4b566bc99d596e58638e342b0-Paper.pdf}.
}
\seealso{
\code{\link[=summary.mdyplFit]{summary.mdyplFit()}}
}
\author{
Ioannis Kosmidis \verb{[aut, cre]} \email{ioannis.kosmidis@warwick.ac.uk}
}
