% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORI.R
\name{drawlatentOR1}
\alias{drawlatentOR1}
\title{Samples latent variable z for OR1 model}
\usage{
drawlatentOR1(y, x, beta, w, theta, tau2, delta)
}
\arguments{
\item{y}{observed ordinal outcomes, column vector of size \eqn{(n x 1)}.}

\item{x}{covariate matrix of size \eqn{(n x k)} including a column of ones with or without column names.}

\item{beta}{Gibbs draw of \eqn{\beta}, a column vector of size \eqn{(k x 1)}.}

\item{w}{latent weights, column vector of size size \eqn{(n x 1)}.}

\item{theta}{(1-2p)/(p(1-p)).}

\item{tau2}{2/(p(1-p)).}

\item{delta}{row vector of cutpoints including (-Inf, Inf).}
}
\value{
column vector of latent variable z from a univariate truncated distribution.
}
\description{
This function samples the latent variable z from a univariate truncated
normal distribution for OR1 model (ordinal quantile model with 3 or more outcomes).
}
\details{
This function samples the latent variable z from a univariate truncated normal
distribution.
}
\examples{
set.seed(101)
data("data25j4")
y <- data25j4$y
xMat <- data25j4$x
p <- 0.25
beta <- c(0.3990094, 0.8168991, 2.8034963)
w <- 1.114347
theta <- 2.666667
tau2 <- 10.66667
delta <- c(-0.002570995,  1.044481071)
output <- drawlatentOR1(y, xMat, beta, w, theta, tau2, delta)

# output
#   0.6261896 3.129285 2.659578 8.680291
#   13.22584 2.545938 1.507739 2.167358
#   15.03059 -3.963201 9.237466 -1.813652
#   2.718623 -3.515609 8.352259 -0.3880043
#   -0.8917078 12.81702 -0.2009296 1.069133 ... soon

}
\references{
Albert, J., and Chib, S. (1993). “Bayesian Analysis of Binary and Polychotomous
Response Data.” Journal of the American Statistical
Association, 88(422): 669–679. DOI: 10.1080/01621459.1993.10476321

Casella, G., and George, E. I. (1992). “Explaining the Gibbs Sampler.”
The American Statistician, 46(3): 167-174. DOI: 10.1080/00031305.1992.10475878

Geman, S., and Geman, D. (1984). “Stochastic Relaxation,
Gibbs Distributions, and the Bayesian Restoration of Images.”
IEEE Transactions an Pattern Analysis and Machine Intelligence,
6(6): 721-741. DOI: 10.1109/TPAMI.1984.4767596

Robert, C. P. (1995). “Simulation of truncated normal variables.” Statistics and
Computing, 5: 121–125. DOI: 10.1007/BF00143942
}
\seealso{
Gibbs sampling, truncated normal distribution,
\link[truncnorm]{rtruncnorm}
}
