% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridoptim.R
\name{gridoptim}
\alias{gridoptim}
\title{Grid search to find optimal threshold values of toxicity and efficacy interval}
\usage{
gridoptim(pi = rep(1/6, 6), phi, phi1, phi2, delta, delta1, n = 100)
}
\arguments{
\item{pi}{Prior probability of 6 hypotheses (default: c(1/6,1/6,1/6,1/6,1/6,1/6))}

\item{phi}{Target toxicity probability}

\item{phi1}{Lower bound of toxicity probability}

\item{phi2}{Upper bound of toxicity probability}

\item{delta}{Target efficacy probability}

\item{delta1}{Lower bound of efficacy probability}

\item{n}{Number of patients (default: 100)}
}
\value{
Optimal threshold values
}
\description{
Given non-informative prior probabilities of the six hypotheses, a grid
search approach is used to find the optimal threshold values.
}
\examples{
gridoptim(phi=0.33,phi1=0.033,phi2=0.462,delta=0.70,delta1=0.42);
}
