% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/BN-methods.R
\docType{methods}
\name{cpts}
\alias{cpts}
\alias{cpts,BN}
\alias{cpts,BN-method}
\title{get the list of conditional probability tables of a \code{\link{BN}}.}
\usage{
cpts(x)

\S4method{cpts}{BN}(x)
}
\arguments{
\item{x}{an object.}
}
\value{
list of the conditional probability tables of the desired object.
}
\description{
Return the list of conditional probability tables of the variables of a \code{\link{BN}} object.
Each probability table is associated to the corresponding variable, and its dimensions are named according
to the variable they represent.
}
\details{
Each conditional probability table is represented as a multidimensional array.
The ordering of the dimensions of each variable is not guaranteed to follow the actual conditional distribution.
E.g. dimensions for conditional probability \code{P(C|A,B)} can be either \code{(C,A,B)} or \code{(A,B,C)}, depending on
if some operations have been performed, or how the probability table has been computed.
Users should not rely on dimension numbers, but should instead select the dimensions using their names.
}

