% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learn-params.R
\name{bnc}
\alias{bnc}
\title{Learn network structure and parameters.}
\usage{
bnc(dag_learner, class, dataset, smooth, dag_args = NULL, awnb_trees = NULL,
  awnb_bootstrap = NULL, manb_prior = NULL, wanbia = NULL)
}
\arguments{
\item{dag_learner}{A character. Name of the structure learning function.}

\item{class}{A character. Name of the class variable.}

\item{dataset}{The data frame from which to learn network structure and 
parameters.}

\item{smooth}{A numeric. The smoothing value (\eqn{\alpha}) for Bayesian 
parameter estimation. Nonnegative.}

\item{dag_args}{A list. Optional additional arguments to \code{dag_learner}.}

\item{awnb_trees}{An integer. The number (\eqn{M}) of bootstrap samples to 
generate.}

\item{awnb_bootstrap}{A numeric. The size of the bootstrap subsample, 
relative to the size of \code{dataset} (given in [0,1]).}

\item{manb_prior}{A numeric. The prior probability for an arc between the 
class and any feature.}

\item{wanbia}{A logical. If \code{TRUE}, WANBIA feature weighting is
performed.}
}
\description{
A convenience function to learn the structure and parameters in a single 
call. Must provide the name of the structure learning algorithm function;
see \code{\link{bnclassify}} for the list.
}
\examples{
data(car)
nb <- bnc('nb', 'class', car, smooth = 1)
nb_manb <- bnc('nb', 'class', car, smooth = 1, manb_prior = 0.3)
ode_cl_aic <- bnc('tan_cl', 'class', car, smooth = 1, dag_args = list(score = 'aic'))
}
