% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/0bnclassify-doc.R, R/learn-struct.R
\name{wrapper}
\alias{bsej}
\alias{fssj}
\alias{tan_hc}
\alias{tan_hcsp}
\alias{wrapper}
\title{Learns Bayesian network classifiers in a wrapper fashion.}
\usage{
fssj(class, dataset, k, epsilon = 0.01, smooth = 0.01)

bsej(class, dataset, k, epsilon = 0.01, smooth = 0.01)

tan_hc(class, dataset, k, epsilon = 0.01, smooth = 0.01)

tan_hcsp(class, dataset, k, epsilon = 0.01, smooth = 0.01)
}
\arguments{
\item{class}{A character. Name of the class variable.}

\item{dataset}{The data frame from which to learn the classifier.}

\item{k}{An integer. The number of folds.}

\item{epsilon}{A numeric. Minimum absolute improvement required to keep
  searching.}

\item{smooth}{A nonnegative numeric. The smoothing value for Bayesian
parameter estimation.}
}
\description{
Each candidate structure is evaluated according to the cross-validated
estimate of predictive accuracy.
}
\references{
Pazzani M (1996). Constructive induction of Cartesian product
  attributes. In \emph{Proceedings of the Information, Statistics and
  Induction in Science Conference (ISIS-1996)}, pp. 66-77

  Koegh E and Pazzani M (2002).Learning the structure of augmented Bayesian
  classifiers. In \emph{International Journal on Artificial Intelligence
  Tools}, \bold{11}(4), pp. 587-601.
}

