% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/0bnclassify-doc.R, R/anb-dag.R, R/bnc-dag-operate.R
\name{bnc_dag_object}
\alias{bnc_dag_object}
\alias{class_var}
\alias{families}
\alias{feature_families}
\alias{features}
\alias{is_anb}
\alias{is_nb}
\alias{is_ode}
\alias{is_semi_naive}
\alias{narcs}
\alias{vars}
\title{A Bayesian network classifier structure.}
\usage{
class_var(x)

features(x)

vars(x)

families(x)

feature_families(x)

narcs(x)

is_semi_naive(x)

is_anb(x)

is_nb(x)

is_ode(x)
}
\arguments{
\item{x}{The bnc_dag_object}
}
\description{
You can query this object using the following functions.
}
\section{Functions}{
\itemize{
\item \code{class_var}: Returns the class variable.

\item \code{features}: Returns the features.

\item \code{vars}: Returns all variables (i.e., features + class).

\item \code{families}: Returns the family of each variable.

\item \code{feature_families}: Returns the family of each feature.

\item \code{narcs}: Returns the number of arcs.

\item \code{is_semi_naive}: Returns TRUE if \code{x} is a semi-naive Bayes.

\item \code{is_anb}: Returns TRUE if \code{x} is an augmented naive Bayes.

\item \code{is_nb}: Returns TRUE if \code{x} is a naive Bayes.

\item \code{is_ode}: Returns TRUE if \code{x} is a one-dependence estimator.
}}

