% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_imm.R
\name{imm}
\alias{imm}
\alias{IMMfull}
\alias{IMMbsc}
\alias{IMMabc}
\title{Interference measurement model by Oberauer and Lin (2017).}
\usage{
imm(
  resp_error,
  nt_features,
  nt_distances,
  set_size,
  regex = FALSE,
  version = "full",
  ...
)

IMMfull(resp_error, nt_features, nt_distances, set_size, regex = FALSE, ...)

IMMbsc(resp_error, nt_features, nt_distances, set_size, regex = FALSE, ...)

IMMabc(resp_error, nt_features, set_size, regex = FALSE, ...)
}
\arguments{
\item{resp_error}{The name of the variable in the provided dataset containing
the response error. The response Error should code the response relative to
the to-be-recalled target in radians. You can transform the response error
in degrees to radian using the \code{deg2rad} function.}

\item{nt_features}{A character vector with the names of the non-target
variables. The non_target variables should be in radians and be centered
relative to the target. Alternatively, if regex=TRUE, a regular
expression can be used to match the non-target feature columns in the
dataset.}

\item{nt_distances}{A vector of names of the columns containing the distances
of non-target items to the target item. Alternatively, if regex=TRUE, a regular
expression can be used to match the non-target distances columns in the
dataset. Only necessary for the \code{bsc} and \code{full} versions.}

\item{set_size}{Name of the column containing the set size variable (if
set_size varies) or a numeric value for the set_size, if the set_size is
fixed.}

\item{regex}{Logical. If TRUE, the \code{nt_features} and \code{nt_distances} arguments
are interpreted as a regular expression to match the non-target feature
columns in the dataset.}

\item{version}{Character. The version of the IMM model to use. Can be one of
\code{full}, \code{bsc}, or \code{abc}. The default is \code{full}.}

\item{...}{used internally for testing, ignore it}
}
\value{
An object of class \code{bmmodel}
}
\description{
Three versions of the Interference measurement model by Oberauer and Lin (2017). - the full, bsc, and abc.
\code{IMMfull()}, \code{IMMbsc()}, and \code{IMMabc()} are deprecated and will be removed in the future.
Please use \code{imm(version = 'full')}, \code{imm(version = 'bsc')}, or \code{imm(version = 'abc')} instead.
}
\details{
\itemize{
\item \strong{Domain:} Visual working memory
\item \strong{Task:} Continuous reproduction
\item \strong{Name:} Interference measurement model by Oberauer and Lin (2017).
\item \strong{Citation:}
\itemize{
\item Oberauer, K., & Lin, H.Y. (2017). An interference model of visual working memory. Psychological Review, 124(1), 21-59
}
}
\subsection{Version: \code{full}}{
\itemize{
\item \strong{Requirements:}
\itemize{
\item The response vairable should be in radians and represent the angular error relative to the target
}
}
\itemize{
\item The non-target features should be in radians and be centered relative to the target
}
\itemize{
\item \strong{Parameters:}
\itemize{
\item \code{mu1}: Location parameter of the von Mises distribution for memory responses (in radians). Fixed internally to 0 by default.
\item \code{kappa}: Concentration parameter of the von Mises distribution
\item \code{a}: General activation of memory items
\item \code{c}: Context activation
\item \code{s}: Spatial similarity gradient
}
\item \strong{Fixed parameters:}
\itemize{
\item \code{mu1} = 0
\item \code{mu2} = 0
\item \code{kappa2} = -100
}
\item \strong{Default parameter links:}
\itemize{
\item mu1 = tan_half; kappa = log; a = log; c = log; s = log
}
\item \strong{Default priors:}
\itemize{
\item \code{mu1}:
\itemize{
\item \code{main}: student_t(1, 0, 1)
}
\item \code{kappa}:
\itemize{
\item \code{main}: normal(2, 1)
\item \code{effects}: normal(0, 1)
}
\item \code{a}:
\itemize{
\item \code{main}: normal(0, 1)
\item \code{effects}: normal(0, 1)
}
\item \code{c}:
\itemize{
\item \code{main}: normal(0, 1)
\item \code{effects}: normal(0, 1)
}
\item \code{s}:
\itemize{
\item \code{main}: normal(0, 1)
\item \code{effects}: normal(0, 1)
}
}
}
}

\subsection{Version: \code{bsc}}{
\itemize{
\item \strong{Requirements:}
\itemize{
\item The response vairable should be in radians and represent the angular error relative to the target
}
}
\itemize{
\item The non-target features should be in radians and be centered relative to the target
}
\itemize{
\item \strong{Parameters:}
\itemize{
\item \code{mu1}: Location parameter of the von Mises distribution for memory responses (in radians). Fixed internally to 0 by default.
\item \code{kappa}: Concentration parameter of the von Mises distribution
\item \code{c}: Context activation
\item \code{s}: Spatial similarity gradient
}
\item \strong{Fixed parameters:}
\itemize{
\item \code{mu1} = 0
\item \code{mu2} = 0
\item \code{kappa2} = -100
}
\item \strong{Default parameter links:}
\itemize{
\item mu1 = tan_half; kappa = log; c = log; s = log
}
\item \strong{Default priors:}
\itemize{
\item \code{mu1}:
\itemize{
\item \code{main}: student_t(1, 0, 1)
}
\item \code{kappa}:
\itemize{
\item \code{main}: normal(2, 1)
\item \code{effects}: normal(0, 1)
}
\item \code{c}:
\itemize{
\item \code{main}: normal(0, 1)
\item \code{effects}: normal(0, 1)
}
\item \code{s}:
\itemize{
\item \code{main}: normal(0, 1)
\item \code{effects}: normal(0, 1)
}
}
}
}

\subsection{Version: \code{abc}}{
\itemize{
\item \strong{Requirements:}
\itemize{
\item The response vairable should be in radians and represent the angular error relative to the target
}
}
\itemize{
\item The non-target features should be in radians and be centered relative to the target
}
\itemize{
\item \strong{Parameters:}
\itemize{
\item \code{mu1}: Location parameter of the von Mises distribution for memory responses (in radians). Fixed internally to 0 by default.
\item \code{kappa}: Concentration parameter of the von Mises distribution
\item \code{a}: General activation of memory items
\item \code{c}: Context activation
}
\item \strong{Fixed parameters:}
\itemize{
\item \code{mu1} = 0
\item \code{mu2} = 0
\item \code{kappa2} = -100
}
\item \strong{Default parameter links:}
\itemize{
\item mu1 = tan_half; kappa = log; a = log; c = log
}
\item \strong{Default priors:}
\itemize{
\item \code{mu1}:
\itemize{
\item \code{main}: student_t(1, 0, 1)
}
\item \code{kappa}:
\itemize{
\item \code{main}: normal(2, 1)
\item \code{effects}: normal(0, 1)
}
\item \code{a}:
\itemize{
\item \code{main}: normal(0, 1)
\item \code{effects}: normal(0, 1)
}
\item \code{c}:
\itemize{
\item \code{main}: normal(0, 1)
\item \code{effects}: normal(0, 1)
}
}
}

Additionally, all imm models have an internal parameter that is fixed to 0 to
allow the model to be identifiable. This parameter is not estimated and is not
included in the model formula. The parameter is:
\itemize{
\item b = "Background activation (internally fixed to 0)"
}
}
}
\examples{
\dontshow{if (isTRUE(Sys.getenv("BMM_EXAMPLES"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# load data
data <- oberauer_lin_2017

# define formula
ff <- bmmformula(
  kappa ~ 0 + set_size,
  c ~ 0 + set_size,
  a ~ 0 + set_size,
  s ~ 0 + set_size
)

# specify the full IMM model with explicit column names for non-target features and distances
# by default this fits the full version of the model
model1 <- imm(resp_error = "dev_rad",
              nt_features = paste0('col_nt', 1:7),
              nt_distances = paste0('dist_nt', 1:7),
              set_size = 'set_size')

# fit the model
fit <- bmm(formula = ff,
           data = data,
           model = model1,
           cores = 4,
           backend = 'cmdstanr')

# alternatively specify the IMM model with a regular expression to match non-target features
# this is equivalent to the previous call, but more concise
model2 <- imm(resp_error = "dev_rad",
              nt_features = 'col_nt',
              nt_distances = 'dist_nt',
              set_size = 'set_size',
              regex = TRUE)

# fit the model
fit <- bmm(formula = ff,
           data = data,
           model = model2,
           cores = 4,
           backend = 'cmdstanr')

# you can also specify the `bsc` or `abc` versions of the model to fit a reduced version
model3 <- imm(resp_error = "dev_rad",
              nt_features = 'col_nt',
              set_size = 'set_size',
              regex = TRUE,
              version = 'abc')
fit <- bmm(formula = ff,
           data = data,
           model = model3,
           cores = 4,
           backend = 'cmdstanr')
\dontshow{\}) # examplesIf}
}
\keyword{bmmodel}
\keyword{deprecated}
