% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{fit_info}
\alias{fit_info}
\title{Extract information from a brmsfit object}
\usage{
fit_info(fit, what)
}
\arguments{
\item{fit}{A brmsfit object, or a list of brmsfit objects}

\item{what}{String. What to return:
\itemize{
\item "time" for the sampling time per chain
\item "time_mean" for the mean sampling time
}}
}
\value{
Depends on \code{what} and the class of \code{fit}. For \code{brmsfit} objects,
information about the single fit is returned. For \code{brmsfit_list} objects, a
list or data.frame with the information for each fit is returned.
\itemize{
\item "time": A data.frame with the sampling time per chain
\item "time_mean": A named numeric vector with the mean sampling time
}
}
\description{
Extract information from a brmsfit object
}
\examples{
\dontshow{if (isTRUE(Sys.getenv("BMM_EXAMPLES"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
fit <- bmm(
  formula = bmmformula(c ~ 1, kappa ~ 1),
  data = data.frame(y = rsdm(1000)),
  model = sdm(resp_error = "y")
)

fit_info(fit, "time")
\dontshow{\}) # examplesIf}
}
\keyword{extract_info}
