% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers-data.R
\name{circle_transform}
\alias{circle_transform}
\alias{deg2rad}
\alias{rad2deg}
\title{Convert degrees to radians or radians to degrees.}
\usage{
deg2rad(deg)

rad2deg(rad)
}
\arguments{
\item{deg}{A numeric vector of values in degrees.}

\item{rad}{A numeric vector of values in radians.}
}
\value{
A numeric vector of the same length as \code{deg} or \code{rad}.
}
\description{
The helper functions \code{deg2rad} and \code{rad2deg} should add
convenience in transforming data from degrees to radians and from radians to
degrees.
}
\examples{
degrees <- runif(100, min = 0, max = 360)
radians <- deg2rad(degrees)
degrees_again <- rad2deg(radians)
}
\keyword{transform}
