% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictorResponseFunctions.R
\name{PredictorResponseUnivar}
\alias{PredictorResponseUnivar}
\title{Plot univariate predictor-response function on a new grid of points}
\usage{
PredictorResponseUnivar(fit, y = NULL, Z = NULL, X = NULL,
  which.z = 1:ncol(Z), preds.method = "approx", ngrid = 50,
  q.fixed = 0.5, sel = NULL, min.plot.dist = Inf, center = TRUE,
  z.names = colnames(Z), ...)
}
\arguments{
\item{fit}{An object containing the results returned by a the \code{kmbayes} function}

\item{y}{a vector of outcome data of length \code{n}.}

\item{Z}{an \code{n}-by-\code{M} matrix of predictor variables to be included in the \code{h} function. Each row represents an observation and each column represents an predictor.}

\item{X}{an \code{n}-by-\code{K} matrix of covariate data where each row represents an observation and each column represents a covariate. Should not contain an intercept column.}

\item{which.z}{vector identifying which predictors (columns of \code{Z}) should be plotted}

\item{preds.method}{method for obtaining posterior summaries at a vector of new point. Currently only implemented for \code{preds.method = "approx"}}

\item{ngrid}{number of grid points to cover the range of each predictor (column in \code{Z})}

\item{q.fixed}{vector of quantiles at which to fix the remaining predictors in \code{Z}}

\item{sel}{logical expression indicating samples to keep; defaults to keeping the second half of all samples}

\item{min.plot.dist}{specifies a minimum distance that a new grid point needs to be from an observed data point in order to compute the prediction; points further than this will not be computed}

\item{center}{flag for whether to scale the exposure-response function to have mean zero}

\item{z.names}{optional vector of names for the columns of \code{z}}

\item{...}{other argumentd to pass on to the prediction function}
}
\description{
Plot univariate predictor-response function on a new grid of points
}

