% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getbizdays.R
\name{getbizdays}
\alias{getbizdays}
\title{Obtaining business days using other dates (or month or year) as reference}
\usage{
getbizdays(ref, cal = bizdays.options$get("default.calendar"))
}
\arguments{
\item{ref}{a reference which represents a month or year, where the date has
to be found.}

\item{cal}{the calendar's name

\code{getbizdays} returns the number of working days according to a reference
that can be a month or an year.
This reference can be passed as a character vector representing months
or years, or as a numeric vector representing years. The ISO format must be 
used to represent years or months with character vectors.}
}
\description{
Calculates the number of business days for some specific periof of a year
or a month.
\code{getbizdays} returns the number of business days according to a
reference than can be another date, a month or an year.
}
\examples{
# for years
getbizdays(2022:2024, "actual")

# for months
getbizdays("2022-12", "actual")

# using dates as references for months
dts <- seq(as.Date("2022-01-01"), as.Date("2022-12-01"), by = "months")
getbizdays(dts, "actual")
}
