% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getdate.R
\name{ref}
\alias{ref}
\alias{ref.Date}
\alias{ref.character}
\alias{ref.numeric}
\title{Creates date references to be used in \code{getdate}}
\usage{
ref(x, ...)

\method{ref}{Date}(x, ym = c("month", "year"), ...)

\method{ref}{character}(x, ...)

\method{ref}{numeric}(x, ...)
}
\arguments{
\item{x}{a \code{Date} vector, a character vector (specifying dates, months
or years) or a numeric vector (specifying years)}

\item{...}{additional arguments

If a date (\code{character} or \code{Date}) is passed to \code{ref} it has to
specified whether the reference is to the month or the year of the given
date. This is set in the argument \code{ym} that accepts \code{month} (default) or 
\code{year}.}

\item{ym}{a character string with the values \code{month} or \code{year} (see
Details)}
}
\description{
Date references are specifically months or years to be used in 
\code{getdate}.
Months and years can be specified directly or can be base on a given date.
\code{getdate} returns a date that is in the reference passed.
}
\examples{
ref(as.Date("2018-01-01"), "month") # refers to 2018-01
ref("2018-01-01", "month")          # refers to 2018-01
ref("2018-01-01", "year")           # refers to 2018

ref(c("2018-01", "2018-02")) # refers to 2018-01 and 2018-02
ref("2018") # refers to 2018
ref(2010:2018) # refers to all years from 2010 to 2018

}
