% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bizdays.R
\name{bizdayse}
\alias{bizdayse}
\title{Business days and current days equivalence}
\usage{
bizdayse(dates, curd, cal)
}
\arguments{
\item{dates}{the reference dates}

\item{curd}{the amount of current days}

\item{cal}{the calendar's name}
}
\value{
An \code{integer} representing an amount of business days.
}
\description{
\code{bizdayse} stands for business days equivalent, it returns the amount
of business days equivalent to a given number of current days.
}
\details{
Let us suppose I have a reference date \code{dates} and I offset that date
by \code{curd} current days. \code{bizdayse} returns the business days
between the reference date and the new date offset by \code{curd} current
days.

This is equivalent to
\preformatted{
refdate <- Sys.Date()
curd <- 10
newdate <- refdate + 10 # offset refdate by 10 days
bizdays(refdate, newdate) # bizdayse(refdate, 10)
}
}
\section{Date types accepted}{


The argument \code{dates} accepts \code{Date} objects and any
object that returns a valid \code{Date} object when passed through
\code{as.Date}, which include all \code{POSIX*} classes and \code{character}
objects with ISO formatted dates.
}

\section{Recycle rule}{


These arguments handle the recycle rule so a vector of dates and a vector of
numbers can be provided and once those vectors differs in length the recycle
rule is applied.
}

\examples{
create.calendar("Brazil/ANBIMA", holidaysANBIMA, weekdays=c("saturday", "sunday"))
bizdayse("2013-01-02", 3, "Brazil/ANBIMA")

}
