% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.biwavelet.R
\name{plot.biwavelet}
\alias{plot.biwavelet}
\title{Plot \code{biwavelet} objects}
\usage{
\method{plot}{biwavelet}(x, ncol = 64, fill.cols = NULL, xlab = "Time",
  ylab = "Period", tol = 1, plot.cb = FALSE, plot.phase = FALSE,
  type = "power.corr.norm", plot.coi = TRUE, lwd.coi = 1,
  col.coi = "white", lty.coi = 1, alpha.coi = 0.5, plot.sig = TRUE,
  lwd.sig = 4, col.sig = "black", lty.sig = 1, bw = FALSE,
  legend.loc = NULL, legend.horiz = FALSE,
  arrow.len = min(par()$pin[2]/30, par()$pin[1]/40), arrow.lwd = arrow.len *
  0.3, arrow.cutoff = 0.8, arrow.col = "black", xlim = NULL,
  ylim = NULL, zlim = NULL, xaxt = "s", yaxt = "s", form = "\%Y", ...)
}
\arguments{
\item{x}{\code{biwavelet} object generated by \code{\link{wt}},
\code{\link{xwt}}, or \code{\link{wtc}}.}

\item{ncol}{Number of colors to use.}

\item{fill.cols}{Vector of fill colors to be used. Users can specify color
vectors using \code{\link{colorRampPalette}} or
\code{\link[RColorBrewer]{brewer.pal}} from package
\code{\link[RColorBrewer]{RColorBrewer}}. Value \code{NULL} generates
MATLAB's jet color palette.}

\item{xlab}{X-label of the figure.}

\item{ylab}{Y-label of the figure.}

\item{tol}{Tolerance level for significance contours. Sigificance contours
will be drawn around all regions of the spectrum where
\code{spectrum/percentile >= tol}. If strict \eqn{i^{th}} percentile
regions are desired, then \code{tol} must be set to 1.}

\item{plot.cb}{Plot color bar if \code{TRUE}.}

\item{plot.phase}{Plot phases with black arrows.}

\item{type}{Type of plot to create. Can be \code{power} to plot the power,
\code{power.corr} to plot the bias-corrected power, \code{power.norm} to
plot the power normalized by the variance, \code{power.corr.norm} to plot
the bias-corrected power normalized by the variance, \code{wavelet} to plot
the wavelet coefficients, or \code{phase} to plot the phase.}

\item{plot.coi}{Plot cone of influence (COI) as a semi-transparent polygon if
\code{TRUE}. Areas that fall within the polygon can be affected by edge
effects.}

\item{lwd.coi}{Line width of COI.}

\item{col.coi}{Color of COI.}

\item{lty.coi}{Line type of COI. Value 1 is for solide lines.}

\item{alpha.coi}{Transparency of COI. Range is 0 (full transparency) to 1 (no
transparency).}

\item{plot.sig}{Plot contours for significance if \code{TRUE}.}

\item{lwd.sig}{Line width of significance contours.}

\item{col.sig}{Color of significance contours.}

\item{lty.sig}{Line type of significance contours.}

\item{bw}{plot in black and white if \code{TRUE}.}

\item{legend.loc}{Legend location coordinates as defined by
\code{\link[fields]{image.plot}}.}

\item{legend.horiz}{Plot a horizontal legend if \code{TRUE}.}

\item{arrow.len}{Size of the arrows. Default is based on plotting region.}

\item{arrow.lwd}{Width/thickness of arrows.}

\item{arrow.cutoff}{Cutoff value for plotting phase arrows. Phase arrows will
be be plotted in regions where the significance of the zvalues exceeds
\code{arrow.cutoff} for \code{\link{wt}} and \code{\link{xwt}} objects. For
\code{\link{pwtc}} and \code{\link{wtc}} objects, phase arrows will be
plotted in regions where the \code{rsq} value exceeds \code{arrow.cutoff}.
If the object being plotted does not have a significance field, regions
whose z-values exceed the \code{arrow.cutoff} quantile will be plotted.}

\item{arrow.col}{Color of arrows.}

\item{xlim}{The x limits.}

\item{ylim}{The y limits.}

\item{zlim}{The z limits.}

\item{xaxt}{Add x-axis? Use \code{n} for none.}

\item{yaxt}{Add y-axis? Use \code{n} for none.}

\item{form}{Format to use to display dates on the x-axis.
See \code{\link{Date}} for other valid formats.}

\item{\dots}{Other parameters.}
}
\description{
Plot \code{biwavelet} objects such as the cwt, cross-wavelet and wavelet
coherence.
}
\details{
Arrows pointing to the right mean that \code{x} and \code{y} are in phase.

Arrows pointing to the left mean that \code{x} and \code{y} are in anti-phase.

Arrows pointing up mean that \code{x} leads \code{y} by \eqn{\pi/2}.

Arrows pointing down mean that \code{y} leads \code{x} by \eqn{\pi/2}.
}
\examples{
library(biwavelet)

t1 <- cbind(1:100, rnorm(100))
t2 <- cbind(1:100, rnorm(100))

# Continuous wavelet transform
wt.t1 <- wt(t1)

# Plot power
# Make room to the right for the color bar
par(oma = c(0, 0, 0, 1), mar = c(5, 4, 4, 5) + 0.1)
plot(wt.t1, plot.cb = TRUE, plot.phase = FALSE)

# Cross-wavelet transform
xwt.t1t2 <- xwt(t1, t2)

# Plot cross-wavelet
par(oma = c(0, 0, 0, 1), mar = c(5, 4, 4, 5) + 0.1)
plot(xwt.t1t2, plot.cb = TRUE)

# Example of bias-correction
t1 <- sin(seq(0, 2 * 5 * pi, length.out = 1000))
t2 <- sin(seq(0, 2 * 15 * pi, length.out = 1000))
t3 <- sin(seq(0, 2 * 40 * pi, length.out = 1000))

# This aggregate time series should have the same power
# at three distinct periods
s <- t1 + t2 + t3

# Compare plots to see bias-effect on CWT:
# biased power spectrum artificially
# reduces the power of higher-frequency fluctuations.
wt1 <- wt(cbind(1:1000, s))
par(mfrow = c(1,2))
plot(wt1, type = "power.corr.norm", main = "Bias-corrected")
plot(wt1, type = "power.norm", main = "Biased")

# Compare plots to see bias-effect on XWT:
# biased power spectrum artificially
# reduces the power of higher-frequency fluctuations.
x1 <- xwt(cbind(1:1000, s), cbind(1:1000, s))
par(mfrow = c(1,2))

plot(x1, type = "power.corr.norm", main = "Bias-corrected")
plot(x1, type = "power.norm", main = "Biased")
}
\references{
Cazelles, B., M. Chavez, D. Berteaux, F. Menard, J. O. Vik, S. Jenouvrier,
and N. C. Stenseth. 2008. Wavelet analysis of ecological time series.
\emph{Oecologia} 156:287-304.

Grinsted, A., J. C. Moore, and S. Jevrejeva. 2004. Application of the cross
wavelet transform and wavelet coherence to geophysical time series.
\emph{Nonlinear Processes in Geophysics} 11:561-566.

Torrence, C., and G. P. Compo. 1998. A Practical Guide to Wavelet Analysis.
\emph{Bulletin of the American Meteorological Society} 79:61-78.

Liu, Y., X. San Liang, and R. H. Weisberg. 2007. Rectification of the Bias in
the Wavelet Power Spectrum. \emph{Journal of Atmospheric and Oceanic
Technology} 24:2093-2102.
}
\seealso{
\code{\link{image.plot}}
}
\author{
Tarik C. Gouhier (tarik.gouhier@gmail.com)
Code based on WTC MATLAB package written by Aslak Grinsted.
}
