# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Optimized "wt.bases.dog" function.
#' 
#' This si a C++ version optimized for speed.
#' Computes the wavelet as a function of Fourier frequency
#' for "dog" mother wavelet.
#' 
#' @author Viliam Simko
#'
#' @param k vector of frequencies at which to calculate the wavelet.
#' @param scale the wavelet scale.
#' @param param nondimensional parameter specific to the wavelet function.
#' @return Returns a list containing:
#' \item{daughter}{wavelet function}
#' \item{fourier.factor}{ratio of fourier period to scale}
#' \item{coi}{cone of influence}
#' \item{dof}{degrees of freedom for each point in wavelet power}
#' 
#' @note This c++ implementation is approx. 50% faster than the original R code
rcpp_wt_bases_dog <- function(k, scale, param = -1L) {
    .Call('biwavelet_rcpp_wt_bases_dog', PACKAGE = 'biwavelet', k, scale, param)
}

#' Optimized "wt.bases.morlet" function.
#'
#' This si a C++ version optimized for speed.
#' Computes the wavelet as a function of Fourier frequency
#' for "morlet" mother wavelet.
#'
#' @author Viliam Simko
#'
#' @param k vector of frequencies at which to calculate the wavelet.
#' @param scale the wavelet scale.
#' @param param nondimensional parameter specific to the wavelet function.
#' @return Returns a list containing:
#' \item{daughter}{wavelet function}
#' \item{fourier.factor}{ratio of fourier period to scale}
#' \item{coi}{cone of influence}
#' \item{dof}{degrees of freedom for each point in wavelet power}
#'
#' @note This c++ implementation is approx. 60% faster than the original R code
rcpp_wt_bases_morlet <- function(k, scale, param = -1L) {
    .Call('biwavelet_rcpp_wt_bases_morlet', PACKAGE = 'biwavelet', k, scale, param)
}

#' Optimized "wt.bases.paul" function.
#'
#' This si a C++ version optimized for speed.
#' Computes the wavelet as a function of Fourier frequency
#' for "paul" mother wavelet.
#'
#' @author Viliam Simko
#'
#' @param k vector of frequencies at which to calculate the wavelet.
#' @param scale the wavelet scale.
#' @param param nondimensional parameter specific to the wavelet function.
#' @return Returns a list containing:
#' \item{daughter}{wavelet function}
#' \item{fourier.factor}{ratio of fourier period to scale}
#' \item{coi}{cone of influence}
#' \item{dof}{degrees of freedom for each point in wavelet power}
#'
#' @note This c++ implementation is approx. 59% faster than the original R code
rcpp_wt_bases_paul <- function(k, scale, param = -1L) {
    .Call('biwavelet_rcpp_wt_bases_paul', PACKAGE = 'biwavelet', k, scale, param)
}

