% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgp.r
\name{dgp_cop}
\alias{dgp_cop}
\title{Generate bivariate data with different margins and dependence structures from Archimedian copulas.}
\usage{
dgp_cop(n, family = "clayton", margins = c("norm", "norm"),
  paramMargins = list(list(mean = 0, sd = 1), list(mean = 0, sd = 1)),
  rho = 2, ...)
}
\arguments{
\item{n}{sample size.}

\item{family}{the copula of type Archimedian.}

\item{margins}{the margins to be specified.}

\item{paramMargins}{parameters of marginal distributions.}

\item{rho}{the copula parameter}

\item{...}{further arguments for function \code{\link{mvdc}}.}
}
\value{
a \eqn{n x 2} matrix of the data which is an object of class \code{\link{mvdc}}.
}
\description{
Generate bivariate data with different margins and dependence structures from Archimedian copulas.
}
\seealso{
\code{\link{rMvdc}} and \code{\link{mvdc}} in \code{copula-package} for details.
}
\author{
Nadja Klein.
}
