% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_font.R
\name{as_bm_font}
\alias{as_bm_font}
\alias{as_bm_font.default}
\alias{as_bm_font.list}
\title{Coerce to bitmap font objects}
\usage{
as_bm_font(x, ..., comments = NULL, properties = NULL)

\method{as_bm_font}{default}(x, ..., comments = NULL, properties = NULL)

\method{as_bm_font}{list}(x, ..., comments = NULL, properties = NULL)
}
\arguments{
\item{x}{An object that can reasonably be coerced to a \code{bm_font()} object.}

\item{...}{Further arguments passed to or from other methods.}

\item{comments}{An optional character vector of (global) font comments.}

\item{properties}{An optional named list of font metadata.}
}
\value{
A \code{bm_font()} object.
}
\description{
\code{as_bm_font()} turns an existing object into a \code{bm_font()} object.
}
\examples{
  plus_sign <- matrix(0L, nrow = 9L, ncol = 9L)
  plus_sign[5L, 3:7] <- 1L
  plus_sign[3:7, 5L] <- 1L
  plus_sign_glyph <- bm_bitmap(plus_sign)

  space_glyph <- bm_bitmap(matrix(0L, nrow = 9L, ncol = 9L))

  l <- list()
  l[[str2ucp("+")]] <- plus_sign_glyph
  l[[str2ucp(" ")]] <- space_glyph
  font <- as_bm_font(l)
  is_bm_font(font)

}
\seealso{
\code{\link[=bm_font]{bm_font()}}
}
