% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bm_bitmap.R
\name{plot.bm_bitmap}
\alias{plot.bm_bitmap}
\alias{as.raster.bm_bitmap}
\title{Plot bitmap object}
\usage{
\method{plot}{bm_bitmap}(x, ..., col = c("grey80", "black", "grey40"), interpolate = FALSE)

\method{as.raster}{bm_bitmap}(x, ..., col = c("grey80", "black", "grey40"))
}
\arguments{
\item{x}{A \code{bm_bitmap()} object}

\item{...}{Passed to \code{\link[grid:grid.raster]{grid::grid.raster()}}.}

\item{col}{Character vector of R color specifications.}

\item{interpolate}{Passed to \code{\link[grid:grid.raster]{grid::grid.raster()}}.}
}
\value{
A \code{grid} rastergrob grob object silently.
As a side effect will draw to graphics device.
}
\description{
\code{plot.bm_bitmap()} plots a bitmap object to the graphics device.
It is a wrapper around \code{grid::grid.raster()} and \code{as.raster.bm_bitmap()}
which converts a bitmap glyph object to a raster object.
}
\examples{
  font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
  font <- read_hex(font_file)
  capital_r <- bm_extend(font[[str2ucp("R")]], left = 1L)
  capital_r <- bm_extend(capital_r, sides = 1L, value = 2L)  # add a border effect

  plot(capital_r)

  grid::grid.newpage()
  plot(capital_r, col = c("yellow", "blue", "red"))
}
\seealso{
\code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=as.raster.bm_bitmap]{as.raster.bm_bitmap()}}
}
