% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_history_parameter.R
\name{evaluate_history_option}
\alias{evaluate_history_option}
\title{Evaluates whether and how to fit a cumulative history parameter.}
\usage{
evaluate_history_option(param_name, param_value, randomN, upperLimit)
}
\arguments{
\item{param_name}{Name of the parameter.}

\item{param_value}{Value from the \code{\link{fit_cumhist}} function call.}

\item{randomN}{Number of levels for the random variable.}

\item{upperLimit}{Upper limit for a valid \code{param_value}.}
}
\value{
a list with \code{<param_name>_option} and \code{fixed_<param_name>}.
}
\description{
Evaluation is based on the \code{param_value}.
\enumerate{
\item A single positive number (>0) that is used for all participants and runs.
\item \code{NULL} (default) -  a \emph{single} value will be fitted for all participants
and runs, also applied if \code{randomN == 1}.
\item \code{"random"} - an independent value is fitted for each random cluster.
\item \code{"1|random"}- a value for a random cluster is sampled from a population
distribution, i.e., pooled parameter values via a multilevel model.
}
}
\examples{
evaluate_history_option("tau", 1, 1, Inf)
}
\keyword{internal}
