# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Computes cumulative history
#'
#' Computes cumulative history based on common \code{history} values and
#' \code{normalized_tau} and \code{mixed_state} that are defined for each
#' random cluster / individual.
#'
#' @param df DataFrame with \code{"state"} (integer, 1 and 2 clear state, 3 - mixed state), \code{"duration"} (double),
#'   \code{"irandom"} (integer, 1-based index of a random cluster), \code{"run_start"} (integer, 1 for the first entry of
#'   the run, 0 othwerwise), \code{"session_tmean"} (double)
#' @param normalized_tau DoubleVector A normalized tau value for each random cluster / individual. Thus, its length must be
#'   equal to the number of unique indexes in \code{df["irandom"]}.
#' @param mixed_state DoubleVector A values used for the mixed state for each random cluster / individual.
#'   Thus, its length must be equal to the number of unique indexes in \code{df["irandom"]}.
#' @param history_init DoubleVector, size 2. Initial values of history for a run.
#' @return NumericMatrix, size \code{df.nrows()} × 2. Computed history values for each state.
#' @export
#'
#' @examples
#' df <- preprocess_data(br_singleblock, state="State", duration="Duration")
#' fast_history_compute(df, 1, 0.5, c(0, 0))
fast_history_compute <- function(df, normalized_tau, mixed_state, history_init) {
    .Call(`_bistablehistory_fast_history_compute`, df, normalized_tau, mixed_state, history_init)
}

