% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sites_EG.R
\name{plot_sites_EG}
\alias{plot_sites_EG}
\alias{plot_sites_E}
\alias{plot_sites_G}
\title{Representation of sites selected to be surveyed}
\usage{
plot_sites_EG(master_selection, selection_type, variable_1 = NULL,
              variable_2 = NULL, selection_number = 1,
              region_border = TRUE, mask_border = FALSE, col_all = NULL,
              col_sites = NULL, col_pre = NULL, cex_all = 0.7,
              cex_sites = 1, cex_pre = 1, pch_all = 16, pch_sites = 16,
              pch_pre = 16, add_main = TRUE)

plot_sites_E(master_selection, selection_type, variable_1 = NULL,
             variable_2 = NULL, selection_number = 1, col_all = NULL,
             col_sites = NULL, col_pre = NULL, cex_all = 0.7,
             cex_sites = 1, cex_pre = 1, pch_all = 16, pch_sites = 16,
             pch_pre = 16, main = "", xlab = NULL, ylab = NULL)

plot_sites_G(master_selection, selection_type, selection_number = 1,
             region_border = TRUE, mask_border = FALSE, col_all = NULL,
             col_sites = NULL, col_pre = NULL, cex_all = 0.7,
             cex_sites = 1, cex_pre = 1, pch_all = 16, pch_sites = 16,
             pch_pre = 16)
}
\arguments{
\item{master_selection}{master_selection object derived from functions
\code{\link{random_selection}}, \code{\link{uniformG_selection}},
\code{\link{uniformE_selection}}, or \code{\link{EG_selection}}.}

\item{selection_type}{(character) type of selection depending on the function
used to select sites. The options available are "random"
(\code{\link{random_selection}}), "G" (\code{\link{uniformG_selection}}),
"E" (\code{\link{uniformE_selection}}), and "EG"
(\code{\link{EG_selection}}).}

\item{variable_1}{(character or numeric) name or position of the first
variable (x-axis) to be plotted in environmental space. Default = NULL,
required when \code{selection_type} = "random" or "G".}

\item{variable_2}{(character or numeric) name or position of the second
variable (y-axis) to be plotted in environmental space. It must be different
from the first one. Default = NULL, required when \code{selection_type} =
"random" or "G".}

\item{selection_number}{(numeric) number of selection to be plotted.
Default = 1.}

\item{region_border}{(logical) whether to add region border to the plot.
Default = TRUE.}

\item{mask_border}{(logical) whether to add mask border to the plot. Ignored
if mask is not present in \code{master_selection}. Default = FALSE.}

\item{col_all}{colors for points in all points in the region of interest.
The default, NULL, uses a light gray color.}

\item{col_sites}{color for selected sites. The default, NULL, uses
a blue color to represent selected sites.}

\item{col_pre}{color for preselected sites. The default, NULL, uses
a red color to represent preselected sites. Ignored if preselected sites are
not present in \code{master_selection}.}

\item{cex_all}{(numeric) value defining magnification of all points
relative to the default. Default = 0.7.}

\item{cex_sites}{(numeric) value defining magnification of selected sites
relative to the default. Default = 1.}

\item{cex_pre}{(numeric) value defining magnification of preselected sites
relative to the default. Default = 1. Ignored if preselected sites are
not present in \code{master_selection}.}

\item{pch_all}{(numeric) integer specifying a symbol when plotting all
points. Default = 16.}

\item{pch_sites}{(numeric) integer specifying a symbol when plotting points
of selected sites. Default = 16.}

\item{pch_pre}{(numeric) integer specifying a symbol when plotting points
of preselected sites. Default = 16. Ignored if preselected sites are
not present in \code{master_selection}.}

\item{add_main}{(logical) whether or not to add fixed titles to the plot.
Default = TRUE. Titles added are "Environmental space" and "Geographic
space".}

\item{main}{(character) the main title for the plot.}

\item{xlab}{(character) label for the x axis. The default, NULL, uses
variable_1.}

\item{ylab}{(character) label for the y axis. The default, NULL, uses
variable_2.}
}
\value{
\code{plot_sites_EG} returns a two-panel plot showing the selected sites.
They are show in both spaces, geographic and environmental.

\code{plot_sites_E} returns a plot of selected sites in environmental space.

\code{plot_sites_G} returns a plot of selected sites in geographic space.
}
\description{
Plots representing sites (all and selected for survey) in
environmental and/or geographic space.
}
\examples{
# Data
data("m_selection", package = "biosurvey")

# Plotting
plot_sites_EG(m_selection, selection_type = "E")
plot_sites_E(m_selection, selection_type = "E")
plot_sites_G(m_selection, selection_type = "E")
}
