% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block_sample.R
\name{block_sample}
\alias{block_sample}
\title{Selection of blocks in environmental space}
\usage{
block_sample(master, expected_blocks, selection_type = "uniform",
             replicates = 10, set_seed = 1)
}
\arguments{
\item{master}{master_matrix object derived from the function
\code{\link{prepare_master_matrix}} or a master_selection object derived
from functions \code{\link{random_selection}},
\code{\link{uniformG_selection}}, or \code{\link{uniformE_selection}}.}

\item{expected_blocks}{(numeric) number of blocks to be selected.}

\item{selection_type}{(character) type of selection. Two options are
available: "uniform" and "random". Default = "uniform".}

\item{replicates}{(numeric) number of thinning replicates performed to
select blocks uniformly. Default = 10.}

\item{set_seed}{(numeric) integer value to specify a initial seed.
Default = 1.}
}
\value{
An S3 object of class master_matrix or master_selection, containing the same
elements found in the input object, with an additional column in the
master_matrix data.frame containing a binary code for selected (1) and
non-selected (0) blocks.
}
\description{
Select a user-defined number of blocks in environmental space
to be used in further analysis to define sampling sites for a survey system.
}
\details{
When blocks in \code{master} are defined using the option "equal_points"
(see \code{\link{make_blocks}}), "uniform" \code{selection_type} could
result in blocks with high density per area being overlooked.
}
\examples{
# Data
data("m_matrix", package = "biosurvey")

# Making blocks for analysis
m_blocks <- make_blocks(m_matrix, variable_1 = "PC1",
                        variable_2 = "PC2", n_cols = 10, n_rows = 10,
                        block_type = "equal_area")

# Checking column names and values in variables to define initial distance
colnames(m_blocks$data_matrix)
summary(m_blocks$data_matrix[, c("PC1", "PC2")])

# Selecting blocks uniformly in E space
block_sel <- block_sample(m_blocks, expected_blocks = 10,
                          selection_type = "uniform")

head(block_sel$data_matrix)
}
