% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{models_lnln}
\alias{models_lnln}
\alias{fit_lnln}
\alias{plot_lnln}
\alias{interpolate_lnln}
\title{Model functions for data requiring ln-ln-transformation to fit a model.}
\usage{
fit_lnln(x, y)

plot_lnln(x, y)

interpolate_lnln(y, model)
}
\arguments{
\item{x}{The x coordinates of the points.}

\item{y}{The y coordinates of the points.}

\item{model}{The line model.}
}
\value{
\itemize{
\item \code{fit_lnln}: The model.
\item \code{plot_lnln}: The plot.
\item \code{interpolate_lnln}: The calculated x values.
}
}
\description{
Use these functions to transform x and y using the natural logarithm and
calculate a linear model, plot the model and use it to calculate x-values
from the model data and y-values (inverse function).

Those function are intended to be used in \link{set_calc_concentrations} /
\link{sets_read} to be applied to the calibrators (\code{fit_lnln}) and interpolate
concentrations from the raw values (\code{interpolate_lnln}). Use \code{plot_lnln}
to visually inspect goodness of fit.
\itemize{
\item \code{fit_lnln}: Apply ln to x and y and calculate a linear model from x and y.
\item \code{plot_lnln}: Draw the plot for the model that can be calculated with
\code{fit_lnln}. Uses \link[ggplot2:ggplot]{ggplot2::ggplot} if available.
\item \code{interpolate_lnln}: Inverse \code{fit_lnln} using \code{model} and calculate x
values from y values.
}
}
\examples{
# generate data
x <- c(2.718282, 20.085537, 54.598150, 1096.633158)
# x is known for these values
y_known <- c(33.11545, 665.14163, 2980.95799, 268337.28652)
# we will calculate x for those:
y_unknown <- c(148.4132, 13359.7268, 59874.1417)

model <- fit_lnln(x = x, y = y_known)
model

plot_lnln(x = x, y = y_known)

interpolate_lnln(y = y_unknown, model)

rm(x, y_known, y_unknown, model)

}
\seealso{
\link{set_calc_concentrations}, \link{sets_read}, \link{models_linear}
}
