% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_BinaryTransformation.R
\name{bm_BinaryTransformation}
\alias{bm_BinaryTransformation}
\alias{bm_BinaryTransformation,data.frame-method}
\alias{bm_BinaryTransformation,matrix-method}
\alias{bm_BinaryTransformation,numeric-method}
\alias{bm_BinaryTransformation,SpatRaster-method}
\title{Convert probability values into binary values using a predefined threshold}
\usage{
bm_BinaryTransformation(data, threshold, do.filtering = FALSE)

\S4method{bm_BinaryTransformation}{data.frame}(data, threshold, do.filtering = FALSE)

\S4method{bm_BinaryTransformation}{matrix}(data, threshold, do.filtering = FALSE)

\S4method{bm_BinaryTransformation}{numeric}(data, threshold, do.filtering = FALSE)

\S4method{bm_BinaryTransformation}{SpatRaster}(data, threshold, do.filtering = FALSE)
}
\arguments{
\item{data}{a \code{vector}, a \code{matrix}, \code{data.frame}, or a 
\code{\link[terra:rast]{SpatRaster}} containing the data to be converted}

\item{threshold}{a \code{numeric} or a \code{vector} of \code{numeric} corresponding to 
the threshold used to convert the given data}

\item{do.filtering}{(\emph{optional, default} \code{FALSE}) \cr 
A \code{logical} value defining whether filtered data should be returned, or binary one 
(see Details)}
}
\value{
An object of the same class than \code{data} and containing either
 binary (\code{0} or \code{1}) values, or filtered values.
}
\description{
This internal \pkg{biomod2} function allows to convert probability (not necessary 
between \code{0} and \code{1}) values into binary presence-absence (\code{0} or \code{1}) values 
according to a predefined threshold (see Details).
}
\details{
If \code{data} is a \code{vector}, \code{threshold} should be a single 
\code{numeric} value. \cr
If \code{data} is a \code{matrix}, \code{data.frame} or 
\code{\link[terra:rast]{SpatRaster}}, \code{threshold} should be a
\code{vector} containing as many values as the number of columns or 
layers contained in \code{data}. If only one \code{numeric} value is given,
 the same threshold will be applied to all columns or layers. 
\cr \cr

If \code{do.filtering = FALSE}, binary (\code{0} or \code{1}) values are returned. \cr 
If \code{do.filtering = TRUE}, values will be \emph{filtered} according to \code{threshold}, 
meaning that :
\itemize{
  \item \code{data < threshold} will return 0
  \item \code{data >= threshold } will return the actual values of \code{data} (not 
  transformed in \code{1})
}
}
\examples{

## Generate a 0-1000 vector (normal distribution)
vec.d <- rnorm(100, 500, 100)

## From continuous to binary / filtered vector
vec.d_bin <- bm_BinaryTransformation(data = vec.d, threshold = 500)
vec.d_filt <- bm_BinaryTransformation(data = vec.d, threshold = 500, do.filtering = TRUE)
cbind(vec.d, vec.d_bin, vec.d_filt)


}
\seealso{
\code{\link{BIOMOD_Projection}}, \code{\link{BIOMOD_EnsembleForecasting}}

Other Secundary functions: 
\code{\link{bm_CrossValidation}()},
\code{\link{bm_FindOptimStat}()},
\code{\link{bm_MakeFormula}()},
\code{\link{bm_ModelingOptions}()},
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotEvalMean}()},
\code{\link{bm_PlotRangeSize}()},
\code{\link{bm_PlotResponseCurves}()},
\code{\link{bm_PlotVarImpBoxplot}()},
\code{\link{bm_PseudoAbsences}()},
\code{\link{bm_RunModelsLoop}()},
\code{\link{bm_SRE}()},
\code{\link{bm_SampleBinaryVector}()},
\code{\link{bm_SampleFactorLevels}()},
\code{\link{bm_Tuning}()},
\code{\link{bm_VariablesImportance}()}
}
\author{
Wilfried Thuiller, Damien Georges
}
\concept{Secundary functions}
\keyword{binary}
\keyword{convert}
\keyword{filter}
\keyword{threshold}
