% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anv.binned.R
\name{anv.binned}
\alias{anv.binned}
\title{ANOVA in kernel distribution estimation with binned data.}
\usage{
anv.binned(n, y, trt.w, abs.values = FALSE, alpha = 0.05, B = 500)
}
\arguments{
\item{n}{Vector of positive integers. Sizes of the complete samples corresponding to each treatment.}

\item{y}{Vector. Observed values. They define the extremes of the sequence of intervals in which data is binned.}

\item{trt.w}{Matrix. Proportion of observations within each interval. Each column corresponds to a different treatment.}

\item{abs.values}{Logical. Indicates if the values of trt.w are given in absolute (TRUE) or relative (FALSE) format.}

\item{alpha}{Real number between 0 and 1. Significance level of the test.}

\item{B}{Positive integer. Number of bootstrap replicates used to compute the confidence bands.}
}
\value{
TRUE if the null hypothesis is accepted and FALSE otherwise.
}
\description{
ANOVA in kernel distribution estimation with binned data.
}
\details{
Constructs bootstrap confidence bands for each treatment and checks whether they overlap or not.
}
\references{
\insertRef{TesisMiguel2015}{binnednp}
}
