% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step4_rpl_e.R
\name{rpl_e}
\alias{rpl_e}
\title{Step 4: Replaying the experiment with optimal parameters}
\usage{
rpl_e(
  data,
  id = NULL,
  result,
  model,
  model_name,
  param_prefix = "param_",
  n_trials = NULL
)
}
\arguments{
\item{data}{[data.frame] 

This data should include the following mandatory columns: 
 \itemize{
   \item \code{sub} "Subject"
   \item \code{time_line} "Block" "Trial"
   \item \code{L_choice} "L_choice"
   \item \code{R_choice} "R_choice"
   \item \code{L_reward} "L_reward"
   \item \code{R_reward} "R_reward"
   \item \code{sub_choose} "Sub_Choose"
 }}

\item{id}{[CharacterVector]

 A vector specifying the subject ID(s) for which parameters should be
  fitted. The function will process only the subjects provided in this
  vector.

 To fit all subjects, you can either explicitly set the argument as
  \code{id = unique(data$Subject)} or leave it as the default
  (\code{id = NULL}). Both approaches will direct the function to fit
  parameters for every unique subject in the dataset.

 It is strongly recommended to avoid using simple numeric sequences like
  \code{id = 1:4}. This practice can lead to errors if subject IDs are
  stored as strings (e.g., subject four is stored as "004") or are not
  sequentially numbered.
 
 default: \code{id = NULL}}

\item{result}{[data.frame]

Output data generated by the \code{fit_p()} function. Each row represents 
 model fit results for a subject.}

\item{model}{[Function]

A model function to be applied in evaluating the experimental effect.}

\item{model_name}{[string]

A character string specifying the name of the model to extract from 
 the result.}

\item{param_prefix}{[string]

A prefix string used to identify parameter columns in the result data 

default: \code{param_prefix = "param_"}}

\item{n_trials}{[integer]

Represents the total number of trials a single subject experienced
 in the experiment. If this parameter is kept at its default value
 of \code{NULL}, the program will automatically detect how many trials
 a subject experienced from the provided data. This information
 is primarily used for calculating model fit statistics such as
 AIC (Akaike Information Criterion) and BIC (Bayesian Information
 Criterion).
 
 default: \code{n_trials = NULL}}
}
\value{
A list, where each element is a data.frame representing one subject's
 results. Each data.frame includes the value update history for each option,
 the learning rate (\code{eta}), utility function (\code{gamma}), and other 
 relevant information used in each update.
}
\description{
After completing Step 3 using \code{fit_p()} to obtain the optimal parameters
 for each subject and saving the resulting CSV locally, this function
 allows you to load that result dataset. It then applies these optimal
 parameters back into the reinforcement learning model, effectively
 simulating how the "robot" (the model) would make its choices.

Based on this generated dataset, you can then analyze the robot's data
 in the same manner as you would analyze human behavioral data. If a
 particular model's fitted data can successfully reproduce the
 experimental effects observed in human subjects, it strongly suggests
 that this model is a good and valid representation of the process.
}
\examples{
\dontrun{
list <- list()

list[[1]] <- dplyr::bind_rows(
  binaryRL::rpl_e(
    data = binaryRL::Mason_2024_G2,
    result = read.csv("../OUTPUT/result_comparison.csv"),
    model = binaryRL::TD,
    model_name = "TD",
    param_prefix = "param_",
  )
)

list[[2]] <- dplyr::bind_rows(
  binaryRL::rpl_e(
    data = binaryRL::Mason_2024_G2,
    result = read.csv("../OUTPUT/result_comparison.csv"),
    model = binaryRL::RSTD,
    model_name = "RSTD",
    param_prefix = "param_",
  )
)

list[[3]] <- dplyr::bind_rows(
  binaryRL::rpl_e(
    data = binaryRL::Mason_2024_G2,
    result = read.csv("../OUTPUT/result_comparison.csv"),
    model = binaryRL::Utility,
    param_prefix = "param_",
    model_name = "Utility",
  )
)
}
 
}
