% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LOF.R
\name{LOF}
\alias{LOF}
\title{Local Outlier Factor (LOF)}
\usage{
LOF(U, seq_k = c(4, 10, 30), combine = max, robMaha = FALSE,
  log = TRUE)
}
\arguments{
\item{U}{A matrix, from which to detect outliers (rows). E.g. PC scores.}

\item{seq_k}{Sequence of numbers of nearest neighbours to use.
If multiple \code{k} are provided, this returns the combination of statistics.
Default is \code{c(4, 10, 30)} and use \code{max} to combine (see \code{combine}).}

\item{combine}{How to combine results for multiple \code{k}? Default uses \code{max}.}

\item{robMaha}{Whether to use a robust Mahalanobis distance instead of the
normal euclidean distance? Default is \code{FALSE}, meaning using euclidean.}

\item{log}{Whether to return the logarithm of LOFs? Default is \code{TRUE}.}
}
\description{
LOF: Identifying Density-Based Local Outliers.
}
\examples{
X <- readRDS(system.file("testdata", "three-pops.rds", package = "bigutilsr"))
svd <- svd(scale(X))

llof <- LOF(svd$u[, 1:10])
hist(llof, breaks = nclass.scottRob)
tukey_mc_up(llof)

lof <- LOF(svd$u[, 1:10], log = FALSE)
hist(lof, breaks = nclass.scottRob)
str(hist_out(lof))
str(hist_out(lof, nboot = 100))
str(hist_out(lof, nboot = 100, breaks = "FD"))

}
\references{
Breunig, Markus M., et al. "LOF: identifying density-based local outliers."
ACM sigmod record. Vol. 29. No. 2. ACM, 2000.
}
