% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biglasso.R
\name{COPY_biglasso_main}
\alias{COPY_biglasso_main}
\title{Sparse regression path}
\usage{
COPY_biglasso_main(
  X,
  y.train,
  ind.train,
  ind.col,
  covar.train,
  family = c("gaussian", "binomial"),
  alphas = 1,
  K = 10,
  ind.sets = NULL,
  nlambda = 200,
  lambda.min.ratio = if (n > p) 1e-04 else 0.001,
  nlam.min = 50,
  n.abort = 10,
  base.train = NULL,
  pf.X = NULL,
  pf.covar = NULL,
  eps = 1e-05,
  max.iter = 1000,
  dfmax = 50000,
  lambda.min = if (n > p) 1e-04 else 0.001,
  power_scale = 1,
  power_adaptive = 0,
  return.all = FALSE,
  warn = TRUE,
  ncores = 1
)
}
\arguments{
\item{family}{Either "gaussian" (linear) or "binomial" (logistic).}

\item{alphas}{The elastic-net mixing parameter that controls the relative
contribution from the lasso (l1) and the ridge (l2) penalty. The penalty is
defined as \deqn{ \alpha||\beta||_1 + (1-\alpha)/2||\beta||_2^2.}
\code{alpha = 1} is the lasso penalty and \code{alpha} in between \code{0}
(\code{1e-4}) and \code{1} is the elastic-net penalty. Default is \code{1}. \strong{You can
pass multiple values, and only one will be used (optimized by grid-search).}}

\item{K}{Number of sets used in the Cross-Model Selection and Averaging
(CMSA) procedure. Default is \code{10}.}

\item{ind.sets}{Integer vectors of values between \code{1} and \code{K} specifying
which set each index of the training set is in. Default randomly assigns
these values but it can be useful to set this vector for reproducibility,
or if you want to refine the grid-search over \code{alphas} using the same sets.}

\item{nlambda}{The number of lambda values. Default is \code{200}.}

\item{lambda.min.ratio}{The smallest value for lambda, \strong{as a fraction of
lambda.max}. Default is \code{.0001} if the number of observations is larger than
the number of variables and \code{.001} otherwise.}

\item{nlam.min}{Minimum number of lambda values to investigate. Default is \code{50}.}

\item{n.abort}{Number of lambda values for which prediction on the validation
set must decrease before stopping. Default is \code{10}.}

\item{base.train}{Vector of base predictions. Model will be learned starting
from these predictions. This can be useful if you want to previously fit
a model with large-effect variables that you don't want to penalize.}

\item{pf.X}{A multiplicative factor for the penalty applied to each coefficient.
If supplied, \code{pf.X} must be a numeric vector of the same length as \code{ind.col}.
Default is all \code{1}. The purpose of \code{pf.X} is to apply differential
penalization if some coefficients are thought to be more likely than others
to be in the model. Setting SOME to 0 allows to have unpenalized coefficients.}

\item{pf.covar}{Same as \code{pf.X}, but for \code{covar.train}.
You might want to set some to 0 as variables with large effects can mask
small effects in penalized regression.}

\item{eps}{Convergence threshold for inner coordinate descent.
The algorithm iterates until the maximum change in the objective after any
coefficient update is less than \code{eps} times the null deviance.
Default value is \code{1e-5}.}

\item{max.iter}{Maximum number of iterations. Default is \code{1000}.}

\item{dfmax}{Upper bound for the number of nonzero coefficients. Default is
\code{50e3} because, for large data sets, computational burden may be
heavy for models with a large number of nonzero coefficients.}

\item{lambda.min}{This parameter has been renamed \code{lambda.min.ratio} and is
now deprecated.}

\item{power_scale}{When using lasso (alpha = 1), penalization to apply that
is equivalent to scaling genotypes dividing by (standard deviation)^power_scale.
Default is 1 and corresponding to standard scaling. Using 0 would correspond
to using unscaled variables and using 0.5 is Pareto scaling. If you e.g. use
\code{power_scale = c(0, 0.5, 1)}, the best value in CMSA will be used
(just like with \code{alphas}).}

\item{power_adaptive}{Multiplicative penalty factor to apply to variables
in the form of 1 / m_j^power_adaptive, where m_j is the marginal statistic
for variable j. Default is 0, which effectively disables this option.
If you e.g. use \code{power_adaptive = c(0, 0.5, 1.5)}, the best value in CMSA
will be used (just like with \code{alphas}).}

\item{return.all}{Deprecated. Now always return all models.}

\item{warn}{Whether to warn if some models may not have reached a minimum.
Default is \code{TRUE}.}
}
\description{
Fit solution paths for linear or logistic regression models penalized by
lasso (alpha = 1) or elastic-net (1e-4 < alpha < 1) over a grid of values
for the regularization parameter lambda.
}
\details{
The objective function for linear regression (\code{family = "gaussian"}) is
\deqn{\frac{1}{2n}\textrm{RSS} + \textrm{penalty},} for logistic regression
(\code{family = "binomial"}) it is \deqn{-\frac{1}{n} loglike +
\textrm{penalty}.}
}
\keyword{internal}
