% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.big_sp_list}
\alias{predict.big_sp_list}
\title{Predict method}
\usage{
\method{predict}{big_sp_list}(
  object,
  X,
  ind.row = rows_along(X),
  ind.col = attr(object, "ind.col"),
  covar.row = NULL,
  proba = (attr(object, "family") == "binomial"),
  base.row = NULL,
  ...
)
}
\arguments{
\item{object}{Object of class \code{big_sp_list}.}

\item{X}{An object of class \link[=FBM-class]{FBM}.}

\item{ind.row}{An optional vector of the row indices that are used.
If not specified, all rows are used. \strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices that are used.
If not specified, all columns are used. \strong{Don't use negative indices.}}

\item{covar.row}{Matrix of covariables to be added in each model to correct
for confounders (e.g. the scores of PCA), corresponding to \code{ind.row}.
Default is \code{NULL} and corresponds to only adding an intercept to each model.
You can use \code{\link[=covar_from_df]{covar_from_df()}} to convert from a data frame.}

\item{proba}{Whether to return probabilities?}

\item{base.row}{Vector of base predictions, corresponding to \code{ind.row}.}

\item{...}{Not used.}
}
\value{
A vector of scores, corresponding to \code{ind.row}.
}
\description{
Predict method for class \code{big_sp_list}.
}
\seealso{
\link{big_spLinReg} and \link{big_spLogReg}.
}
