% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FBM-code256.R
\docType{class}
\name{FBM.code256-class}
\alias{FBM.code256-class}
\alias{FBM.code256_RC}
\alias{FBM.code256}
\alias{add_code256}
\title{Class FBM.code256}
\usage{
FBM.code256(nrow, ncol, code, ...)

add_code256(x, code, save = FALSE)
}
\arguments{
\item{nrow}{Number of rows.}

\item{ncol}{Number of columns.}

\item{code}{A numeric vector (of length 256).
You should construct it with \code{rep(NA_real_, 256)} and then replace the values
which are of interest for you.}

\item{...}{Arguments passed on to \code{FBM}
\describe{
  \item{init}{Either a single value (e.g. \code{0}) or as many value as the number
of elements of the FBM. \strong{Default doesn't initialize the matrix.}}
  \item{backingfile}{Path to the file storing the Big Matrix on disk.
An extension ".bk" will be automatically added. Default stores in the
temporary directory.}
  \item{create_bk}{Create a backingfile (the default) or use an existing one
(which should be named by the \code{backingfile} parameter and have an
extension ".bk"). For example, this could be used to convert a filebacked
\code{big.matrix} from package \strong{bigmemory} to a \link[=FBM-class]{FBM}.}
  \item{save}{Whether to save the result object in an ".rds" file alongside
the backingfile. Default is \code{FALSE}.}
}}

\item{x}{A \link[=FBM-class]{FBM}.}

\item{save}{Whether to save the result object in an ".rds" file alongside
the backingfile. Default is \code{FALSE}.}
}
\description{
A reference class for storing and accessing up to 256 arbitrary different
values using a Filebacked Big Matrix of type \code{unsigned char}. Compared to a
\link[=FBM-class]{Filebacked Big Matrix}, it adds a slot \code{code} which is used as
a lookup table of size 256.

Wrapper constructor for class \code{FBM.code256}.

Converter from class \code{FBM} to \code{FBM.code256}.
}

\examples{
X <- FBM(10, 10, type = "raw")
X[] <- sample(as.raw(0:3), size = length(X), replace = TRUE)
X[]

code <- rep(NA_real_, 256)
code[1:3] <- c(1, 3, 5)

X.code <- add_code256(X, code)
X.code[]

# Or directly
X.code2 <- FBM.code256(10, 10, code, init = sample(as.raw(0:3), 100, TRUE))
X.code2[]

# Copy the FBM with another code
X.code3 <- X.code$copy(code = rnorm(256))
stopifnot(all.equal(X.code$code256, code))

}
