% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMSA.R
\name{big_CMSA}
\alias{big_CMSA}
\title{Cross-Model Selection and Averaging.}
\usage{
big_CMSA(FUN, feval, X, y.train, ind.train = rows_along(X),
  covar.train = NULL, K = 10, method = c("geometric-median", "mean-wise",
  "median-wise"), ncores = 1, ...)
}
\arguments{
\item{FUN}{Function that computes a linear scores for different
values along a regularization path. For now, this is relevant to
\link{big_spLinReg}, \link{big_spLogReg} and \link{big_spSVM}.
The corresponding \code{<FUN>.predict} function should exists.}

\item{feval}{Customized evaluation function. You should always aim at
maximizing this function. If \code{feval} is like a loss function (which you
want to minimize), you should use its opposite instead.
Its only two arguments should be \code{pred} and \code{target} (e.g. \link{AUC}).}

\item{X}{A \link[=FBM-class]{FBM}.}

\item{y.train}{Vector of responses, corresponding to \code{ind.train}.}

\item{ind.train}{An optional vector of the row indices that are used,
for the training part. If not specified, all rows are used.
\strong{Don't use negative indices.}}

\item{covar.train}{Matrix of covariables to be added in each model to correct
for confounders (e.g. the scores of PCA), corresponding to \code{ind.train}.
Default is \code{NULL} and corresponds to only adding an intercept to each model.}

\item{K}{Number of folds that are used.}

\item{method}{Method for combining vectors of coefficients. The default uses
the \href{https://en.wikipedia.org/wiki/Geometric_median}{geometric median}.}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}

\item{...}{Extra parameters to be passed to FUN.}
}
\value{
A vector of resulting coefficients (intercept excluded), which
corresponds to the training set. You might want to recompute an optimal
intercept if needed.
}
\description{
\enumerate{
\item This function separates the training set in \code{K} folds (e.g. 10).
\item \strong{In turn},
\itemize{
\item each fold is considered as an inner validation set and the others
(K - 1) folds form an inner training set,
\item the model is trained on the inner training set and the corresponding
predictions (scores) for the inner validation set are computed,
\item the vector of scores which maximizes \code{feval} is determined,
\item the vector of coefficients corresponding to the previous vector of
scores is chosen.
}
\item The \code{K} resulting vectors of coefficients are then combined into one
vector (see the \code{method} parameter).
}
}
\details{
For "mean-wise" or "median-wise" method, tests sometimes crash. I haven't
been able to reproduce the bug.
}
