% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bigpca.R
\name{generate.test.matrix}
\alias{generate.test.matrix}
\title{Generate a test matrix of random data}
\usage{
generate.test.matrix(size = 5, row.exp = 2, rand = rnorm,
  dimnames = TRUE, data.frame = FALSE, big.matrix = FALSE,
  file.name = NULL, tracker = TRUE)
}
\arguments{
\item{size}{10^size is the total number of datapoints simulated. 6 or less are fairly quick to generate,
while 7 takes a few seconds. 8 will take under a minute, 9 around ten minutes, 10, perhaps over an hour.
Values are coerced to the range of integers c(2:10).}

\item{row.exp}{similar to 'nrow' when creating a matrix, except this is exponential, giving 10^row.exp rows.}

\item{rand}{a function, must return 'n' values, when rand(n) is called, eg., rnorm(), runif(), numeric()}

\item{dimnames}{logical, whether to generate some row and column names}

\item{data.frame}{logical, whether to return as a data.frame (FALSE means return a matrix)}

\item{big.matrix}{logical, whether to return as a big.matrix (overrides data.frame). If a file.name
is used then the big.matrix will be filebacked and this function returns a list with a
a big.matrix, and the description and backing filenames.}

\item{file.name}{if a character, then will write the result to tab file instead of returning
the object, will return the filename; overrides data.frame. Alternatively, if big.matrix=TRUE,
then this provides the basename for a filebacked big.matrix.}

\item{tracker}{logical, whether to display a progress bar for large matrices (size>7) where progress will be slow}
}
\value{
Returns a random matrix of data for testing/simulation, can be a data.frame or big.matrix if those options are selected
}
\description{
Generates a test matrix of easily specified size and type. Options allow
automated row and column names (which might resemble labels for a SNP analysis)
and return of several different formats, matrix, data.frame or big.matrix.
You can specify the randomisation function (e.g, rnorm, runif, etc), as well
as parameters determining the matrix size. Can also generate big.matrix objects,
and an important feature is that the method to generate big.matrix objects is
scalable so that very large matrices for simulation can be generated only limited
by disk space and not by RAM.
}
\examples{
orig.dir <- getwd(); setwd(tempdir()); # move to temporary dir
mat <- (generate.test.matrix(5)); prv(mat)
lst <- (generate.test.matrix(5,3,big.matrix=TRUE,file.name="bigtest"))
mat <- lst[[1]]; prv(mat); headl(lst[2:3]);
unlink(unlist(lst[2:3]))
setwd(orig.dir) # reset working dir to original
}
\author{
Nicholas Cooper
}

