% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast_mds.R
\name{fast_mds}
\alias{fast_mds}
\title{Fast MDS}
\usage{
fast_mds(x, l, s, k)
}
\arguments{
\item{x}{Data matrix.}

\item{l}{The highest value where classical MDS can be computed efficiently.}

\item{s}{Number of sampling points. It should be 2 x estimated data dimension.}

\item{k}{Number of principal coordinates.}
}
\value{
Returns MDS based on Fast MDS algorithm as well as the first k eigenvalues.
\describe{
\item{points}{MDS}
\item{eigen}{eigenvalues}
}
}
\description{
Performs Multidimensional Scaling based on Yang, Tynia & Liu, Jinze & Mcmillan, Leonard & Wang, Wei. (2006).
}
\examples{
x <- matrix(data = rnorm(4*10000, sd = 10), nrow = 10000)
cmds <- fast_mds(x = x, l = 100, s = 8, k = 2)
head(cmds$points)
cmds$eigen
}
\seealso{
\url{https://arxiv.org/abs/2007.11919}
}
