% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaSandwich-diff-beta-sandwich.R
\name{DiffBetaSandwich}
\alias{DiffBetaSandwich}
\title{Estimate Differences of Standardized Slopes
and the Corresponding Sampling Covariance Matrix}
\usage{
DiffBetaSandwich(object, alpha = c(0.05, 0.01, 0.001))
}
\arguments{
\item{object}{Object of class \code{betasandwich},
that is,
the output of the \code{\link[=BetaHC]{BetaHC()}}, \code{\link[=BetaN]{BetaN()}}, or \code{\link[=BetaADF]{BetaADF()}} functions.}

\item{alpha}{Numeric vector.
Significance level \eqn{\alpha}.}
}
\value{
Returns an object of class \code{diffbetasandwich}
which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{fit}{The argument \code{object}.}
\item{args}{Function arguments.}
\item{vcov}{Sampling covariance matrix of
differences of standardized slopes.}
\item{est}{Vector of
differences of standardized slopes.}
}
}
\description{
Estimate Differences of Standardized Slopes
and the Corresponding Sampling Covariance Matrix
}
\examples{
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
std <- BetaHC(object)
diff <- DiffBetaSandwich(std)
# Methods -------------------------------------------------------
print(diff)
summary(diff)
coef(diff)
vcov(diff)
confint(diff, level = 0.95)

}
\seealso{
Other Beta Sandwich Functions: 
\code{\link{BetaADF}()},
\code{\link{BetaHC}()},
\code{\link{BetaN}()},
\code{\link{RSqBetaSandwich}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Sandwich Functions}
\keyword{betaSandwich}
\keyword{diff}
