% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaMC-p-cor-mc.R
\name{PCorMC}
\alias{PCorMC}
\title{Estimate Squared Partial Correlation Coefficients
and Generate the Corresponding Sampling Distribution
Using the Monte Carlo Method}
\usage{
PCorMC(object)
}
\arguments{
\item{object}{Object of class \code{mc}, that is,
the output of the \code{MC()} function.}
}
\value{
Returns an object
of class \code{betamc} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{object}{The function argument \code{object}.}
\item{thetahatstar}{Sampling distribution of
\eqn{r^{2}_{p}}.}
\item{vcov}{Sampling variance-covariance matrix of
\eqn{r^{2}_{p}}.}
\item{est}{Vector of estimated
\eqn{r^{2}_{p}}.}
\item{fun}{Function used ("PCorMC").}
}
}
\description{
Estimate Squared Partial Correlation Coefficients
and Generate the Corresponding Sampling Distribution
Using the Monte Carlo Method
}
\details{
The vector of squared partial correlation coefficients
(\eqn{r^{2}_{p}})
is derived from each randomly generated vector of parameter estimates.
Confidence intervals are generated by obtaining
percentiles corresponding to \eqn{100(1 - \alpha)\%}
from the generated sampling
distribution of \eqn{r^{2}_{p}},
where \eqn{\alpha} is the significance level.
}
\examples{
# Fit the regression model
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
# Generate the sampling distribution of parameter estimates
# (use a large R, for example, R = 20000 for actual research)
mc <- MC(object, R = 100)
# Generate confidence intervals for standardized regression slopes
rp <- PCorMC(mc)
# Methods --------------------------------------------------------
print(rp)
summary(rp)
coef(rp)
vcov(rp)
confint(rp, level = 0.95)
}
\seealso{
Other Beta Monte Carlo Functions: 
\code{\link{BetaMC}()},
\code{\link{DeltaRSqMC}()},
\code{\link{DiffBetaMC}()},
\code{\link{MC}()},
\code{\link{RSqMC}()},
\code{\link{SCorMC}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Monte Carlo Functions}
\keyword{betaMC}
\keyword{pcor}
