% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaMC-methods.R
\name{vcov.betamc}
\alias{vcov.betamc}
\title{Sampling Covariance Matrix of the Standardized Regression Slopes}
\usage{
\method{vcov}{betamc}(object, ...)
}
\arguments{
\item{object}{Object of class \code{betamc}.}

\item{...}{additional arguments.}
}
\value{
Returns a matrix of the variance-covariance matrix
of standardized slopes.
}
\description{
Sampling Covariance Matrix of the Standardized Regression Slopes
}
\examples{
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
out <- BetaMC(object, R = 100)
# use a large R, for example, R = 20000 for actual research
vcov(out)
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
