% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.benchmark}
\alias{print.benchmark}
\alias{print.summaryBenchmark}
\title{Print method for the \code{benchmark} timings.}
\usage{
\method{print}{benchmark}(x, units = "auto", order = "none",
  relative = "median", details = FALSE, ...)

\method{print}{summaryBenchmark}(x, units = "auto", order = "none", ...)
}
\arguments{
\item{x}{An object of class \code{benchmark}, \code{summaryBenchmark} or
\code{meanBenchmark}.}

\item{units}{Character. The units to be used in printing the timings.
The available units are nanoseconds (\code{"ns"}), microseconds
(\code{"us"}), milliseconds (\code{"ms"}), seconds (\code{"s"}).}

\item{order}{Character. Order results according to this column of the output.}

\item{relative}{Character. The name or index of the column whose values will 
be used to compute relative timings.}

\item{details}{Logical. Show additional detauls about measurement process.}

\item{...}{Arguments passed on to \code{print.data.frame}.}
}
\value{
Apart from the table output produced by \code{summary}, the method
also prints additional information about the benchmarking process (with
\code{details = TRUE}):
\item{Timer precision}{Timer precision in seconds.}
\item{Timer error}{Timer error (overhead) in seconds.}
\item{Replications}{Number of repeats for each expression.}
\item{Expressions order}{Execution regime.}
\item{Garbage collection}{Whether garbage collection took place before each
execution.}
}
\description{
This is universal method of measurement results representation, which can be
called either implicitly or explicitly. The method uses \code{summary} method
to compute aggregated statistics for benchmarking results. \code{print} also
provides additional information about the timer precision and overhead, the
execution regime and the number of repeats.
}
\examples{
a1 <- a2 <- a3 <- a4 <- numeric(0)
res <- benchmark(a1 <- c(a1, 1),
                 a2 <- append(a2, 1),
                 a3[length(a3) + 1] <- 1,
                 a4[[length(a4) + 1]] <- 1)
print(res)

}
\author{
Artem Klevtsov \email{a.a.klevtsov@gmail.com}
}
\seealso{
\code{\link{summary.benchmark}},
\code{\link{mean.benchmark}}
}

