% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detStructAddVarLabels.R,
%   R/detStructAddVarNames.R, R/detStructComputeProducts.R,
%   R/detStructComputeScales.R
\name{detStructAddVarLabels}
\alias{detStructAddVarLabels}
\alias{detStructPreprocessing}
\alias{detStructAddVarNames}
\alias{detStructComputeProducts}
\alias{detStructComputeScales}
\title{Functions to preprocess determinant structures}
\usage{
detStructAddVarLabels(determinantStructure, varLabelDf,
  varNameCol = "varNames.cln", leftAnchorCol = "leftAnchors",
  rightAnchorCol = "rightAnchors", subQuestionCol = "subQuestions",
  questionTextCol = "questionText")

detStructAddVarNames(determinantStructure, names)

detStructComputeProducts(determinantStructure, data, append = TRUE)

detStructComputeScales(determinantStructure, data, append = TRUE,
  separator = "_")
}
\arguments{
\item{determinantStructure}{The \code{\link{determinantStructure}} object.}

\item{varLabelDf}{The variable label dataframe as generated by
\code{\link{processLSvarLabels}}.  It is also possible to specify 'homemade'
dataframe, in which case the column names have to specified (see the next
arguments).}

\item{varNameCol}{The name of the column of the \code{varLabelDf} that
contains the variable name. Only needs to be changed from the default value
if \code{varLabelDf} is not a dataframe as produced by
\code{\link{processLSvarLabels}}.}

\item{leftAnchorCol}{The name of the column of the \code{varLabelDf} that
contains the left anchor. Only needs to be changed from the default value if
\code{varLabelDf} is not a dataframe as produced by
\code{\link{processLSvarLabels}}.}

\item{rightAnchorCol}{The name of the column of the \code{varLabelDf} that
contains the right anchor. Only needs to be changed from the default value
if \code{varLabelDf} is not a dataframe as produced by
\code{\link{processLSvarLabels}}.}

\item{subQuestionCol}{The name of the column of the \code{varLabelDf} that
contains the subquestion. Only needs to be changed from the default value if
\code{varLabelDf} is not a dataframe as produced by
\code{\link{processLSvarLabels}}.}

\item{questionTextCol}{The name of the column of the \code{varLabelDf} that
contains the question text. Only needs to be changed from the default value
if \code{varLabelDf} is not a dataframe as produced by
\code{\link{processLSvarLabels}}.}

\item{names}{A character vector with the variable names. These are matched
against the regular expressions as specified in the
\code{\link{determinantStructure}} object, and any matches will be stored in
the \code{\link{determinantStructure}} object.}

\item{data}{The dataframe containing the data; the variables names specified
in \code{names} (when calling \code{detStructAddVarNames}) must be present
in this dataframe.}

\item{append}{Whether to only return the products or scales, or whether to
append these to the dataframe and return the entire dataframe.}

\item{separator}{The separator to use when constructing the scale variables
names.}
}
\value{
\code{detStructAddVarLabels} and \code{detStructAddVarNames} just
change the \code{\link{determinantStructure}} object;
\code{detStructComputeProducts} and \code{detStructComputeScales} return
either the dataframe with the new variables appended (if \code{append} =
\code{TRUE}) or just a dataframe with the new variables (if \code{append} =
\code{FALSE}).
}
\description{
These functions are used in conjunction with the
\code{\link{determinantStructure}} family of funtions to conveniently work
with determinant structures.
}
\details{
This family of functions will be explained more in detail in a forthcoming
paper.
}
\examples{
### Create some bogus determinant data
detStudy <- mtcars[, c(1, 3:7)];
names(detStudy) <- c('rUse_behav',
                     'rUse_intention',
                     'rUse_attitude1',
                     'rUse_attitude2',
                     'rUse_expAtt1',
                     'rUse_expAtt2');

### Specify the determinant structure

### First a subdeterminant
expAtt <-
  behaviorchange::subdeterminants("Subdeterminants",
                                  "expAtt");

### Then two determinants
attitude <-
  behaviorchange::determinantVar("Determinant",
                                 "attitude",
                                 expAtt);

intention <-
  behaviorchange::determinantVar("ProximalDeterminant",
                                 "intention",
                                 attitude);

### Then the entire determinant strcture
detStruct <-
  behaviorchange::determinantStructure('Behavior',
                                       list('behav',
                                       behaviorRegEx = 'rUse'),
                                       intention);

### Add the variable names
behaviorchange::detStructAddVarNames(detStruct,
                                     names(detStudy));

### Add the determinant scale variable to the dataframe
detStudyPlus <-
  behaviorchange::detStructComputeScales(detStruct,
                                         data=detStudy);

### Show its presence
names(detStudyPlus);
mean(detStudyPlus$rUse_Determinant);

}
\references{
(Forthcoming)
}
\seealso{
\code{\link{determinantStructure}}, \code{\link{determinantVar}},
\code{\link{subdeterminants}}, \code{\link{subdeterminantProducts}},
\code{\link{detStructCIBER}}
}
\keyword{utilities}
