% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change.R
\name{ChangeData}
\alias{ChangeData}
\title{ChangeData}
\usage{
ChangeData(dat, nrepl = 1, replnum = 0.01, rem0 = FALSE, remq0e = FALSE,
  replfree = NULL, xcol = "x", ycol = "y", idcol = "id")
}
\arguments{
\item{dat}{A long form dataframe}

\item{nrepl}{Number of zeros to replace with replacement value (replnum). Can accept either a number or "all" if all zeros should be replaced. Default is to replace the first zero only}

\item{replnum}{Value to replace zeros. Default is .01}

\item{rem0}{If TRUE, removes all 0s in consumption data prior to analysis. Default value is FALSE}

\item{remq0e}{If TRUE, removes consumption and price where price == 0. Default value is FALSE}

\item{replfree}{Optionally replaces price == 0 with specified value.}

\item{xcol}{Column name in dataframe that signifies x values (usually price or the IV)}

\item{ycol}{Column name in dataframe that signifies y values (usually consumption or the DV)}

\item{idcol}{Column name in dataframe that signifies identifying id grouping}
}
\value{
Long form dataframe resembling the originally provided dataframe
}
\description{
Changes demand data
}
\details{
Change demand data in various ways. Ways include replacing any number of 0 values with a replacement number (or remove them completely), removing price and consumption at free, replacing free with some number. This will soon replace ReplaceZeros and certain arguments in FitCurves.
}
\examples{
## Change just the first instance of 0 within each unique value of id with .1
ChangeData(apt, nrepl = 1, replnum = .1)
}
\author{
Brent Kaplan <bkaplan.ku@gmail.com>
}
