% Generated by roxygen2 (4.0.2): do not edit by hand
\name{scale_x_bd}
\alias{scale_x_bd}
\title{Weekend and holiday ignoring position scale for a ggplot.}
\usage{
scale_x_bd(..., business.dates, max.major.breaks = 5,
  max.minor.breaks = max.major.breaks * 5,
  breaks = bd_breaks(business.dates))
}
\arguments{
\item{...}{other arguments passed to \code{\link[ggplot2]{continuous_scale}}}

\item{business.dates}{a vector of \code{Date} objects, sorted ascending}

\item{max.major.breaks}{maximum major breaks \code{\link{bd_breaks}} will return, default=5}

\item{max.minor.breaks}{maximum minor breaks \code{\link{bd_breaks}} will return, default=major*5}

\item{breaks}{a function \code{max => [date range] => breaks}}
}
\description{
Weekend and holiday ignoring position scale for a ggplot.
}
\examples{
\dontrun{
 ggplot(ts, aes(x=date, y=price)) +
   scale_x_bd(business.dates=yahoo('SPY'), max.major.breaks=10, labels=date_format("\%b '\%y"))
}
}

