% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bcp-data.R
\docType{data}
\name{QuebecRivers}
\alias{QuebecRivers}
\title{Quebec river streamflow data}
\format{A matrix containing streamflow amounts for the years 1972 to 1994.}
\source{
The data can be obtained from the Centre d'expertise hydrique Quebec. \url{https://www.cehq.gouv.qc.ca/hydrometrie/index-en.htm}
}
\usage{
QuebecRivers
}
\description{
Annual January to June streamflow amounts (measured in \eqn{L/(km^2 s)}) for four rivers in Quebec: Baleine, Churchill Falls, Manicouagan, and Romaine.
}
\examples{
data("QuebecRivers")
bcpr.rivers <- bcp(QuebecRivers)
plot(bcpr.rivers, main="Quebec River Streamflow Change Point Analysis",
     xlab="Year", xaxlab = 1972:1994)
}
\references{
\enumerate{
\item Xiaofei Wang and John W. Emerson (2015). Bayesian Change Point Analysis of Linear Models on General Graphs, \emph{Working Paper}.
\item L. Perrault \emph{et al.} (2000). Retrospective multivariate Bayesian change-point analysis: a simultaneous single change in the mean of several hydrological sequences, \emph{Stochastic Environmental Research and Risk Assessment}, \bold{14}, 243-261.
}
}
\keyword{datasets}

