% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayeslist-package.R
\docType{data}
\name{london}
\alias{london}
\title{The 2017 London List Experiment}
\format{
A data frame containing the following 18 variables for 3189 observations.

\tabular{lll}{
ID \tab integer \tab Respondent ID number. \cr
age \tab integer \tab Respondent age in years. \cr
agegrp \tab factor \tab Respondent age group. \cr
gender \tab factor \tab YouGov panel measure of gender. \cr
social_grade \tab factor \tab YouGov panel measure of respondent social grade. \cr
qual \tab factor \tab Measure of highest educational qualification from YouGov panel. \cr
validationfactor \tab factor \tab Detailed measure of turnout validation outcome for respondent. \cr
validturnout \tab integer \tab Summary measure of true respondent turnout. \cr
direct \tab integer \tab Response to direct turnout question asked of list experiment control group. \cr
baselineTurnout \tab integer \tab Response to baseline direct turnout question after the election. \cr
listTreat \tab integer \tab Indicator for list experiment treatment group. \cr
listCount \tab integer \tab Reported item count for list experiment question. \cr
qtime \tab numeric \tab Time taken to answer list experiment question, in seconds. \cr
recallfirst \tab character \tab Respondent recall of first item from list question. Open text response. \cr
recalllast \tab character \tab Respondent recall of last item from list question. Open text response. \cr
recallfirst.hand.correct \tab factor \tab Did respondent correctly recall first list experiment item? \cr
recalllast.hand.correct \tab factor \tab Did respondent correctly recall last list experiment item? \cr
comfort \tab numeric \tab How comfortable do you feel revealing whether you did/did not vote in last election? \cr
}
}
\source{
The full data set is available at \doi{10.7910/DVN/W90Q7B})
}
\description{
This dataset is the 2017 London list experiment on voter turnout fielded via online YouGov survey of a sample of 3189 Greater Londoners.The main question reads as follows:
The next question deals with the recent general election on 8th June.
Here is a list of four (five) things that some people did and some people did not do during the election campaign or on Election Day.
Please say how many of these things you did. Here are the four (five) things:
(1) Discussed the election with family and friends;
(2) (Voted in the election);
(3) Criticised a politician on social media;
(4) Avoided watching the leaders debates;
(5) Put up a poster for a political party in my window or garden.
How many of these things did you do?
The second item in bracket is the sensitive item.
In addition to the above list, there is a direct question asking about turnout:
Talking with people about the recent general election on 8th June, we have found that a lot of people didn't manage to vote. How about you, did you manage to vote in the general election?
}
\references{
Kuhn, P. M., & Vivyan, N. (2021). The misreporting trade-off between list experiments and direct questions in practice: Partition validation evidence from two countries. Political Analysis, 1-22.
}
\keyword{datasets}
