% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelLopod.R
\name{modelLopod}
\alias{modelLopod}
\title{Run a  Bayes inference of Landscape Occupancy from Presence-Only Data on Stan}
\usage{
modelLopod(LopodData, varP = F, q = NULL, pmin = 0, CAR = F,
  nChains = 4, warmup = 2000, sampling = 1000, nCores = 4)
}
\arguments{
\item{LopodData}{Object with the data to be used in the Model}

\item{varP}{Boolean. If TRUE, detectability will vary across cells. If FALSE a global value for detectability will be estimated.}

\item{q}{Number between 0 and 1 or NULL. Rate of false detections. If NULL the values will be estimated by the model.}

\item{pmin}{Number between 0 and 1. Minimum value for detectability in a unit in which the species occurs.}

\item{CAR}{Boolean. If TRUE, (and if a adjacency matrix is included in the LopodData object) a conditional auto-regression analysis will be performed for occupancy across units.}

\item{nChains}{Number of Markov chains used by the Stan model.}

\item{warmup}{Number of iterations for each chain to be discarded as warm-up.}

\item{sampling}{Number of iterations for each chain to be sampled (after warm-up).}

\item{nCores}{Number of cores to use when executing the chains in parallel.}
}
\value{
A LopodModel object.
}
\description{
Run a  Bayes inference of Landscape Occupancy from Presence-Only Data on Stan
}
\examples{
data("simSpRecords", package = "bayesLopod")
data("simSpSamplingEffort", package = "bayesLopod")
simSpRasters = xyToRaster(xyRecords = simSpRecords,xySamplingEffort = simSpSamplingEffort,
basemap = NULL, nrows = 10, extentExpansion = 0)
ld_Raster = rasterLopodData(rasterN = simSpRasters[["samplingEffort"]],
rasterY = simSpRasters[["spDetections"]], Adjacency = FALSE )
mLopodRaster = modelLopod(LopodData = ld_Raster, varP = TRUE, q = NULL,
pmin = 0, CAR = FALSE, nChains = 1,warmup = 10,sampling = 10,nCores = 1)

data("Andropogon_shape", package = "bayesLopod")
ld_Shape = shapeLopodData(Shapefile = Andropogon_shape, fieldN = "sampEffort",
fieldY = "detections",  Adjacency = FALSE, keepFields = FALSE)
mLopodShape = modelLopod(LopodData = ld_Shape, varP = FALSE, q = NULL,
pmin = 0, CAR = FALSE, nChains = 1,warmup = 5,sampling = 5,nCores = 1)

\dontrun{
data("simSpRecords", package = "bayesLopod")
data("simSpSamplingEffort", package = "bayesLopod")
simSpRasters = xyToRaster(xyRecords = simSpRecords,xySamplingEffort = simSpSamplingEffort,
basemap = NULL, nrows = 50, extentExpansion = 0)
ld_Raster_adMatrix = rasterLopodData(rasterN = simSpRasters[["samplingEffort"]],
rasterY = simSpRasters[["spDetections"]], Adjacency = TRUE )
mLopodRaster = modelLopod(LopodData = ld_Raster_adMatrix, varP = TRUE, q = NULL,
pmin = 0.1, CAR = FALSE, nChains = 4,warmup = 500,sampling = 100,nCores = 4)

data("Andropogon_shape", package = "bayesLopod")
ld_Shape = shapeLopodData(Shapefile = Andropogon_shape, fieldN = "sampEffort",
fieldY = "detections",  Adjacency = TRUE, keepFields = FALSE)
mLopodShape = modelLopod(LopodData = ld_Shape, varP = TRUE, q = NULL,
pmin = 0, CAR = TRUE, nChains = 4,warmup = 500,sampling = 100,nCores =4)
}
}
