% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{plot.bayesTest}
\alias{plot.bayesTest}
\title{Plot bayesTest objects}
\usage{
\method{plot}{bayesTest}(
  x,
  percentLift = rep(0, length(x$posteriors)),
  priors = TRUE,
  posteriors = TRUE,
  samples = TRUE,
  ...
)
}
\arguments{
\item{x}{an object of class "bayesTest"}

\item{percentLift}{a vector of length(x$posteriors). Each entry corresponds to the percent lift ((A - B) / B) to plot for for
the respective posterior in x. Note this is on a 'point' scale. percentLift = 5 implies you want to test for a 5\% lift.}

\item{priors}{logical indicating whether prior plots should be generated.}

\item{posteriors}{logical indicating whether posterior plots should be generated.}

\item{samples}{logical indicating whether sample plots should be generated.}

\item{...}{graphics parameters to be passed to the plotting routines. (For example \code{p}, in prior plots)}
}
\description{
Plot method for objects of class "bayesTest".
}
\note{
You can either directly plot a bayesTest object (in which case it will plot interactively), or you can save the plot
object to a variable and extract what you need separately. If extracted, you can treat it like any \code{ggplot2} object and
modify it accordingly.

Plots are slightly truncated on the extremes to solve the general case of potentially long tail-ends.
}
\examples{
A_pois <- rpois(100, 5)
B_pois <- rpois(100, 4.7)

AB1 <- bayesTest(A_pois, B_pois, priors = c('shape' = 25, 'rate' = 5), distribution = 'poisson')

plot(AB1)
\donttest{plot(AB1, percentLift = 5)}

\donttest{
    p <- plot(AB1)
    p$posteriors$Lambda
}
\dontrun{p$posteriors$Lambda + ggtitle('yolo') # modify ggplot2 object directly}

}
