% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{batch_log_read}
\alias{batch_log_read}
\title{Read Log File}
\usage{
batch_log_read(path)
}
\arguments{
\item{path}{A string of the path to the directory with the files for processing.}
}
\value{
A tibble with four columns:
\describe{
\item{type}{A character vector indicating SUCCESS or FAILURE}
\item{time}{A hms vector of the file processing time}
\item{file}{A character vector of the file name}
\item{error}{A character vector of the error message (or NA if no error)}
}
}
\description{
Reads the values in the log file created by \code{\link[=batch_run]{batch_run()}}.
}
\examples{
path <- tempdir()
write.csv(mtcars, file.path(path, "file1.csv"))
batch_config(function(x) TRUE, path, regexp = "[.]csv$")
batch_log_read(path)
batch_run(path, ask = FALSE)
batch_log_read(path)
batch_cleanup(path)
unlink(file.path(path, "file1.csv"))
}
\seealso{
\code{\link[=batch_process]{batch_process()}} and \code{\link[=batch_config_read]{batch_config_read()}}
}
