% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{batch_run}
\alias{batch_run}
\title{Runs Batch Processing}
\usage{
batch_run(
  path,
  failed = FALSE,
  progress = FALSE,
  files = NULL,
  seeds = NULL,
  options = furrr::furrr_options(),
  ask = getOption("batchr.ask", TRUE)
)
}
\arguments{
\item{path}{A string of the path to the directory with the files for processing.}

\item{failed}{A logical scalar specifying how to treat files
that previously failed to process. If FALSE (the default) failed files
are excluded, if NA they are included and if TRUE they are only included.}

\item{progress}{A flag specifying whether to print a progress bar.}

\item{files}{A character vector of the remaining files to process.
If \code{NULL} then \code{files} is \code{batch_files_remaining(path, failed)}.}

\item{seeds}{A named list of the L'Ecuyer-CMRG seed to use for each
file. If \code{NULL} then \code{seeds} is \code{batch_seeds(files)}.}

\item{options}{The future specific options to use with the workers.
seed must be \code{FALSE}.}

\item{ask}{A flag specifying whether to ask before starting to process the files.}
}
\value{
An invisible named logical vector indicating for each file
whether it was successfully processed.
}
\description{
Starts (or restarts if previously stopped) processing the remaining files
specified by \code{\link[=batch_config]{batch_config()}}.
}
\details{
\code{batch_run()} logs all file processing attempts together with the
the type (SUCCESS or FAILURE), the
system time in UTC, the file name and any error messages.
The hidden log file can be read using \code{\link[=batch_log_read]{batch_log_read()}}.

\code{\link[=batch_files_remaining]{batch_files_remaining()}} provides a vector of the files that
are remaining to be processed.

When processing is complete the hidden configuration file
and hidden log file can be deleted using \code{\link[=batch_cleanup]{batch_cleanup()}}.

If a remaining file is removed or modified by a separate process,
\code{batch_run()} throws an error.
}
\examples{
path <- tempdir()
write.csv(mtcars, file.path(path, "file1.csv"))
batch_config(function(x) TRUE, path, regexp = "[.]csv$")
batch_run(path, ask = FALSE)
batch_cleanup(path)
unlink(file.path(path, "file1.csv"))
}
\seealso{
\code{\link[=batch_process]{batch_process()}}, \code{\link[=batch_config]{batch_config()}} and
\code{\link[=batch_cleanup]{batch_cleanup()}}
}
