% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanup.R
\name{batch_cleanup}
\alias{batch_cleanup}
\title{Cleanup Batch Processing}
\usage{
batch_cleanup(
  path,
  force = FALSE,
  remaining = FALSE,
  failed = NA,
  recursive = FALSE,
  silent = FALSE
)
}
\arguments{
\item{path}{A string of the path to the directory with the files for processing.}

\item{force}{A flag specifying whether to delete configuration and
log files even if there are files remaining to be processed.}

\item{remaining}{A flag specifying whether to delete
any files that are remaining to be processed
(only applied when \code{force = TRUE}).
Files that have been processed are never deleted.}

\item{failed}{A logical scalar specifying how to treat files
that previously failed to process. If FALSE (the default) failed files
are excluded, if NA they are included and if TRUE they are only included.}

\item{recursive}{A flag specifying whether to recurse into subdirectories
when cleaning up. This is unrelated to the \code{recurse} option
of \code{\link[=batch_config]{batch_config()}} and is only expected to be used
if the user has neglected to clean up multiple nested directories.}

\item{silent}{A flag specifying whether to suppress warnings (and messages).}
}
\value{
A named logical vector indicating which directories
were successfully cleaned up.
}
\description{
Deletes configuration file created by \code{\link[=batch_config]{batch_config()}}
and log file created by \code{\link[=batch_run]{batch_run()}}.
}
\details{
The \code{\link[=batch_completed]{batch_completed()}} function can be used to test
if batch processing is complete.
}
\examples{
path <- tempdir()
write.csv(mtcars, file.path(path, "file1.csv"))
batch_config(function(x) TRUE, path, regexp = "[.]csv$")
batch_run(path, ask = FALSE)
batch_cleanup(path)
unlink(file.path(path, "file1.csv"))
}
\seealso{
\code{\link[=batch_process]{batch_process()}}
}
