% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{setup_mmlglobal}
\alias{setup_mmlglobal}
\title{Setup mmlglobal Design Object}
\usage{
setup_mmlglobal(k, p0, shape1 = 1, shape2 = 1)
}
\arguments{
\item{k}{The number of baskets.}

\item{p0}{A common probability under the null hypothesis.}

\item{shape1}{First common shape parameter of the beta prior.}

\item{shape2}{Second common shape parameter of the beta prior.}
}
\value{
An S3 object of class \code{mmlglobal}
}
\description{
Creates an object of class \code{mmlglobal}.
}
\details{
The class \code{mmlglobal} implements an empirical Bayes method
by Gravestock & Held (2019) which was proposed for borrowing strength
from multiple external studies.
}
\examples{
design_mmlglobal <- setup_mmlglobal(k = 3, p0 = 0.2)
}
\references{
Gravestock, I., & Held, L. (2019). Power priors based on
multiple historical studies for binary outcomes. Biometrical Journal, 61(5),
1201-1218.

Baumann, L., Sauer, L., & Kieser, M. (2024). A basket trial design based on
power priors. arXiv:2309.06988.
}
