% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basket_test.R
\name{basket_test}
\alias{basket_test}
\alias{basket_test,OneStageBasket-method}
\title{Test for the Results of a Basket Trial}
\usage{
basket_test(design, ...)

\S4method{basket_test}{OneStageBasket}(
  design,
  n,
  r,
  lambda,
  weight_fun,
  weight_params = list(),
  globalweight_fun = NULL,
  globalweight_params = list(),
  details = TRUE,
  ...
)
}
\arguments{
\item{design}{An object of class \code{Basket} created by
\code{setupOneStageBasket} or \code{setupTwoStageBasket}.}

\item{...}{Further arguments.}

\item{n}{The sample size per basket.}

\item{r}{The vector of observed responses.}

\item{lambda}{The posterior probability threshold. See details for more
information.}

\item{weight_fun}{Which function should be used to calculate the pairwise
weights.}

\item{weight_params}{A list of tuning parameters specific to
\code{weight_fun}.}

\item{globalweight_fun}{Which function should be used to calculate the
global weights.}

\item{globalweight_params}{A list of tuning parameters specific to
\code{globalweight_fun}.}

\item{details}{Whether a detailed list of results or only the vector
of posterior probabilities is returned.}
}
\value{
If \code{details = TRUE}: A list, including matrices of the weights
that are used for borrowing, posterior distribution parameters for all
baskets without and with borrowing, as well as the posterior probabilities
for all baskets without and with borrowing. If \code{details = FALSE}:
The posterior probabilities for all baskets with borrowing.
}
\description{
\code{basket_test} evaluates the results of a basket trial and calculates
the posterior distributions with and without borrowing.
}
\section{Methods (by class)}{
\itemize{
\item \code{basket_test(OneStageBasket)}: Testing for a single-stage basket design.

}}
\examples{
design <- setupOneStageBasket(k = 3, shape1 = 1, shape2 = 1, p0 = 0.2)
basket_test(design = design, n = 24, r = c(5, 9, 10), lambda = 0.99,
  weight_fun = weights_fujikawa)
}
